/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.guild;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.commands.base.ChatCommands;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.chat.ChatHandler;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessageType;
import earth.terrarium.argonauts.common.handlers.chat.MessageChannel;
import earth.terrarium.argonauts.common.network.messages.ServerboundChatWindowPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;

public final class GuildChatCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandHelper.register(dispatcher, "guild", "chat", GuildChatCommands::openChatScreen);
        CommandHelper.register(dispatcher, "gc", GuildChatCommands::openChatScreen);
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"guild").then(GuildChatCommands.sendMessage("chat")));
        dispatcher.register(GuildChatCommands.sendMessage("gc"));
    }

    public static void openChatScreen(ServerPlayer player) throws MemberException {
        Guild guild = GuildApi.API.get(player);
        if (guild == null) {
            throw MemberException.YOU_ARE_NOT_IN_GUILD;
        }
        ChatCommands.openChatScreen(player, guild, ChatMessageType.GUILD, ConstantComponents.GUILD_CHAT_TITLE);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> sendMessage(String name) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)name).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                Guild guild = GuildApi.API.get(player);
                if (guild == null) {
                    throw MemberException.YOU_ARE_NOT_IN_GUILD;
                }
                String message = StringArgumentType.getString((CommandContext)context, (String)"message");
                MessageChannel channel = ChatHandler.getChannel(guild, ChatMessageType.GUILD);
                ServerboundChatWindowPacket.sendMessage(player, guild, message, channel);
            });
            return 1;
        }));
    }
}

