/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.guild;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.commands.base.ManageCommands;
import earth.terrarium.argonauts.common.commands.guild.GuildCommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMember;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class GuildManageCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"guild").then(GuildManageCommands.invite())).then(GuildManageCommands.remove())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"allies").then(GuildManageCommands.addAlly())).then(GuildManageCommands.removeAlly())));
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> invite() {
        return ManageCommands.invite("guild", MemberException.YOU_CANT_MANAGE_MEMBERS_IN_GUILD, MemberException.PLAYER_ALREADY_IN_GUILD, GuildCommandHelper::getGuildOrThrow);
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> remove() {
        return ManageCommands.remove(MemberException.YOU_CANT_REMOVE_YOURSELF_FROM_GUILD, MemberException.YOU_CANT_REMOVE_GUILD_OWNER, MemberException.YOU_CANT_MANAGE_MEMBERS_IN_GUILD, GuildCommandHelper::getGuildOrThrow, GuildApi.API::leave);
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> addAlly() {
        return Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
            CommandHelper.runAction(() -> {
                GuildMember member = (GuildMember)guild.getMember((Player)player);
                if (player.m_20148_().equals(target.m_20148_())) {
                    throw MemberException.YOU_CANT_ALLY_YOURSELF;
                }
                if (((GuildMembers)guild.members()).isMember(target.m_20148_())) {
                    throw MemberException.PLAYER_ALREADY_IN_GUILD;
                }
                if (!member.hasPermission("manage.members")) {
                    throw MemberException.YOU_CANT_MANAGE_MEMBERS_IN_GUILD;
                }
                ((GuildMembers)guild.members()).ally(target.m_36316_());
                player.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.allied", (Object[])new Object[]{target.m_7755_().getString()}), false);
                target.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_allied", (Object[])new Object[]{player.m_7755_().getString()}), false);
            });
            return 1;
        }));
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> removeAlly() {
        return Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
            CommandHelper.runAction(() -> {
                GuildMember member = (GuildMember)guild.getMember((Player)player);
                if (!member.hasPermission("manage.members")) {
                    throw MemberException.YOU_CANT_MANAGE_MEMBERS_IN_GUILD;
                }
                if (player.m_20148_().equals(target.m_20148_())) {
                    throw MemberException.YOU_CANT_REMOVE_YOURSELF_FROM_GUILD;
                }
                if (((GuildMembers)guild.members()).isLeader(target.m_20148_())) {
                    throw MemberException.YOU_CANT_REMOVE_GUILD_OWNER;
                }
                if (!((GuildMembers)guild.members()).isAllied(target.m_20148_())) {
                    throw MemberException.NOT_AN_ALLY;
                }
                ((GuildMembers)guild.members()).remove(target.m_20148_());
                player.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.remove_ally", (Object[])new Object[]{target.m_7755_().getString()}), false);
                target.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.no_longer_allied", (Object[])new Object[]{guild.displayName()}), false);
            });
            return 1;
        }));
    }
}

