/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.guild;

import com.mojang.brigadier.CommandDispatcher;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import earth.terrarium.argonauts.common.menus.guild.GuildMembersContent;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.network.messages.ClientboundOpenGuildMemberMenuPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class GuildMemberCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandHelper.register(dispatcher, "guild", "members", player -> GuildMemberCommands.openMembersScreen(player, -1));
    }

    public static void openMembersScreen(ServerPlayer player, int selected) throws MemberException {
        if (!NetworkHandler.CHANNEL.canSendPlayerPackets((Player)player)) {
            throw MemberException.NOT_INSTALLED_ON_CLIENT;
        }
        Guild guild = GuildApi.API.get(player);
        if (guild == null) {
            throw MemberException.YOU_ARE_NOT_IN_GUILD;
        }
        Object member = guild.getMember((Player)player);
        NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundOpenGuildMemberMenuPacket(new GuildMembersContent(guild.id(), selected, ((GuildMembers)guild.members()).allMembers(), ((Member)member).hasPermission("manage.members"), ((Member)member).hasPermission("permissions.members")), ConstantComponents.GUILD_MEMBERS_TITLE), (Player)player);
    }
}

