/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.party;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.ChatCommands;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.chat.ChatHandler;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessageType;
import earth.terrarium.argonauts.common.handlers.chat.MessageChannel;
import earth.terrarium.argonauts.common.network.messages.ServerboundChatWindowPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class PartyChatCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandHelper.register(dispatcher, "party", "chat", PartyChatCommands::openChatScreen);
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"party").then(PartyChatCommands.sendMessage()));
    }

    public static void openChatScreen(ServerPlayer player) throws MemberException {
        Party party = PartyApi.API.get((Player)player);
        if (party == null) {
            throw MemberException.YOU_ARE_NOT_IN_PARTY;
        }
        ChatCommands.openChatScreen(player, party, ChatMessageType.PARTY, ConstantComponents.PARTY_CHAT_TITLE);
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> sendMessage() {
        return Commands.m_82127_((String)"chat").then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                Party party = PartyApi.API.get((Player)player);
                if (party == null) {
                    throw MemberException.YOU_ARE_NOT_IN_PARTY;
                }
                String message = StringArgumentType.getString((CommandContext)context, (String)"message");
                MessageChannel channel = ChatHandler.getChannel(party, ChatMessageType.PARTY);
                ServerboundChatWindowPacket.sendMessage(player, party, message, channel);
            });
            return 1;
        }));
    }
}

