/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.handlers.base.members;

import com.mojang.authlib.GameProfile;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.base.members.MemberState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Members<T extends Member>
implements Iterable<T> {
    protected final Map<UUID, T> members = new HashMap<UUID, T>();
    protected GameProfile leader;
    private final Factory<T> factory;

    public Members(GameProfile leader, Factory<T> factory) {
        this.leader = leader;
        this.members.put(leader.getId(), factory.createMember(leader, MemberState.OWNER));
        this.factory = factory;
    }

    @Nullable
    public T get(UUID uuid) {
        return (T)((Member)this.members.get(uuid));
    }

    public int size() {
        return this.members.size();
    }

    public abstract void add(GameProfile var1);

    public void invite(GameProfile profile) {
        this.members.put(profile.getId(), this.factory.createMember(profile, MemberState.INVITED));
    }

    public void ally(GameProfile profile) {
        this.members.put(profile.getId(), this.factory.createMember(profile, MemberState.ALLIED));
    }

    public void remove(UUID uuid) {
        this.members.remove(uuid);
    }

    public abstract void setLeader(GameProfile var1) throws MemberException;

    public T getLeader() {
        return (T)((Member)this.members.get(this.leader.getId()));
    }

    public GameProfile leader() {
        return this.leader;
    }

    public boolean isMember(UUID uuid) {
        return this.members.containsKey(uuid) && ((Member)this.members.get(uuid)).getState().isPermanentMember();
    }

    public boolean isInvited(UUID uuid) {
        return this.members.containsKey(uuid) && ((Member)this.members.get(uuid)).getState() == MemberState.INVITED;
    }

    public boolean isAllied(UUID uuid) {
        return this.members.containsKey(uuid) && ((Member)this.members.get(uuid)).getState() == MemberState.ALLIED;
    }

    public boolean isLeader(UUID uuid) {
        return this.leader.getId().equals(uuid);
    }

    public List<T> allMembers() {
        return new ArrayList<T>(this.members.values());
    }

    public List<T> allies() {
        ArrayList<T> allies = new ArrayList<T>(this.members.values());
        allies.removeIf(member -> member.getState() != MemberState.ALLIED);
        return allies;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        ArrayList<T> members = new ArrayList<T>(this.members.values());
        members.removeIf(member -> !member.getState().isPermanentMember());
        return members.iterator();
    }

    @FunctionalInterface
    public static interface Factory<T extends Member> {
        public T createMember(GameProfile var1, MemberState var2);
    }
}

