/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.handlers.chat;

import com.google.common.primitives.UnsignedInteger;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessage;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessageType;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageChannel {
    private UnsignedInteger nextId = UnsignedInteger.ZERO;
    private final LinkedHashMap<UnsignedInteger, ChatMessage> messages = new LinkedHashMap();
    private final Logger logger = LoggerFactory.getLogger((String)"Argonauts Chat");
    private final ChatMessageType type;

    public MessageChannel(ChatMessageType type) {
        this.type = type;
    }

    public UnsignedInteger add(ChatMessage message) {
        if (this.messages.size() >= 200) {
            this.messages.remove(this.messages.keySet().iterator().next());
        }
        this.messages.put(this.nextId, message);
        this.nextId = this.nextId.plus(UnsignedInteger.ONE);
        this.logger.info(String.format("[%s] <%s> %s", this.type.name(), message.profile().getName(), message.message()));
        return this.nextId.minus(UnsignedInteger.ONE);
    }

    public void remove(UnsignedInteger id) {
        this.messages.remove(id);
    }

    public LinkedHashMap<UnsignedInteger, ChatMessage> messages() {
        return this.messages;
    }
}

