/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.network.messages;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.handlers.GroupType;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Group;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ServerboundSetPermissionPacket(String permission, boolean value, GroupType type, UUID member) implements Packet<ServerboundSetPermissionPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("argonauts", "set_permission");
    public static final PacketHandler<ServerboundSetPermissionPacket> HANDLER = new Handler();

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<ServerboundSetPermissionPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<ServerboundSetPermissionPacket> {
        private Handler() {
        }

        public void encode(ServerboundSetPermissionPacket message, FriendlyByteBuf buffer) {
            buffer.m_130070_(message.permission);
            buffer.writeBoolean(message.value);
            buffer.m_130068_((Enum)message.type);
            buffer.m_130077_(message.member);
        }

        public ServerboundSetPermissionPacket decode(FriendlyByteBuf buffer) {
            return new ServerboundSetPermissionPacket(buffer.m_130277_(), buffer.readBoolean(), (GroupType)buffer.m_130066_(GroupType.class), buffer.m_130259_());
        }

        public PacketContext handle(ServerboundSetPermissionPacket message) {
            return (player, level) -> CommandHelper.runNetworkAction(player, () -> {
                Group group = null;
                if (message.type == GroupType.GUILD) {
                    group = GuildApi.API.get((ServerPlayer)player);
                } else if (message.type == GroupType.PARTY) {
                    group = PartyApi.API.get(player);
                }
                if (group == null) {
                    return;
                }
                Object member = group.getMember(player);
                if (!((Member)member).hasPermission("permissions.members")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                Object selected = group.getMember(message.member());
                if (selected != null && !((Member)selected).getState().isLeader()) {
                    if (!((Member)member).hasPermission(message.permission)) {
                        throw MemberException.YOU_CANT_GIVE_PERMISSIONS;
                    }
                    if (message.value) {
                        ((Member)selected).permissions().add(message.permission);
                    } else {
                        ((Member)selected).permissions().remove(message.permission);
                    }
                }
            });
        }
    }
}

