/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.network.messages;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record ServerboundSetSettingPacket(String setting, boolean value, UUID member, boolean partySettings) implements Packet<ServerboundSetSettingPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("argonauts", "set_setting");
    public static final PacketHandler<ServerboundSetSettingPacket> HANDLER = new Handler();

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<ServerboundSetSettingPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<ServerboundSetSettingPacket> {
        private Handler() {
        }

        public void encode(ServerboundSetSettingPacket message, FriendlyByteBuf buffer) {
            buffer.m_130070_(message.setting);
            buffer.writeBoolean(message.value);
            buffer.m_130077_(message.member);
            buffer.writeBoolean(message.partySettings);
        }

        public ServerboundSetSettingPacket decode(FriendlyByteBuf buffer) {
            return new ServerboundSetSettingPacket(buffer.m_130277_(), buffer.readBoolean(), buffer.m_130259_(), buffer.readBoolean());
        }

        public PacketContext handle(ServerboundSetSettingPacket message) {
            return (player, level) -> CommandHelper.runNetworkAction(player, () -> {
                Party party = PartyApi.API.getPlayerParty(message.member());
                if (party == null) {
                    return;
                }
                PartyMember member = party.getMember(message.member());
                if (!member.hasPermission("manage.settings")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                if (message.partySettings()) {
                    party.settings().set(message.setting, message.value);
                } else {
                    member.settings().set(message.setting, message.value);
                }
            });
        }
    }
}

