/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.forge;

import com.mojang.brigadier.CommandDispatcher;
import earth.terrarium.argonauts.Argonauts;
import earth.terrarium.argonauts.client.ArgonautsClient;
import earth.terrarium.argonauts.client.forge.ArgonautsClientForge;
import earth.terrarium.argonauts.common.commands.ModCommands;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="argonauts")
public class ArgonautsForge {
    public ArgonautsForge() {
        Argonauts.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ArgonautsClientForge::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ArgonautsForge::onClientSetup);
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(ArgonautsForge::onPlayerLoggedIn);
        bus.addListener(ArgonautsForge::onPlayerLoggedOut);
        bus.addListener(ArgonautsForge::registerCommands);
    }

    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Argonauts.onPlayerJoin((Player)player2);
        }
    }

    private static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Argonauts.onPlayerLeave((Player)player2);
        }
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        ArgonautsClient.init();
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }
}

