/*
 * Decompiled with CFR 0.152.
 */
package github.iri.detailed_enchantments.core;

import com.google.common.collect.Multimap;
import github.iri.detailed_enchantments.DetailedEnchantments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class DEUtil {
    private static final Map<Enchantment, MutableComponent> DESCRIPTION_CACHE = new ConcurrentHashMap<Enchantment, MutableComponent>();
    private static final Map<Enchantment, List<Item>> APPLICABLE_ITEMS_CACHE = new ConcurrentHashMap<Enchantment, List<Item>>();

    public static Component getTypeName(MobType type) {
        if (type == MobType.f_21641_) {
            return Component.m_237115_((String)"detailed_enchantments.undead");
        }
        if (type == MobType.f_21642_) {
            return Component.m_237115_((String)"detailed_enchantments.arthropod");
        }
        if (type == MobType.f_21643_) {
            return Component.m_237115_((String)"detailed_enchantments.illager");
        }
        if (type == MobType.f_21644_) {
            return Component.m_237115_((String)"detailed_enchantments.water");
        }
        return Component.m_237115_((String)"detailed_enchantments.all");
    }

    public static Component getRarity(Enchantment.Rarity rarity) {
        if (rarity == Enchantment.Rarity.COMMON) {
            return Component.m_237115_((String)"detailed_enchantments.common");
        }
        if (rarity == Enchantment.Rarity.UNCOMMON) {
            return Component.m_237115_((String)"detailed_enchantments.uncommon");
        }
        if (rarity == Enchantment.Rarity.RARE) {
            return Component.m_237115_((String)"detailed_enchantments.rare");
        }
        if (rarity == Enchantment.Rarity.VERY_RARE) {
            return Component.m_237115_((String)"detailed_enchantments.very_rare");
        }
        return Component.m_237115_((String)"detailed_enchantments.all");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static DamageSource getDamageSource(ProtectionEnchantment pEnchantment) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        DamageSources sources = level.m_269111_();
        if (pEnchantment.f_45124_ == ProtectionEnchantment.Type.FIRE) {
            return sources.m_269387_();
        }
        if (pEnchantment.f_45124_ == ProtectionEnchantment.Type.FALL) {
            return sources.m_268989_();
        }
        if (pEnchantment.f_45124_ == ProtectionEnchantment.Type.EXPLOSION) {
            return sources.m_269093_(null);
        }
        if (pEnchantment.f_45124_ == ProtectionEnchantment.Type.PROJECTILE) {
            return sources.m_269299_(null, null);
        }
        return sources.m_269264_();
    }

    public static MobType getEnchantmentTarget(Enchantment enchant, int level) {
        if (enchant.m_7335_(level, MobType.f_21641_) > 0.0f && enchant.m_7335_(level, MobType.f_21640_) == 0.0f) {
            return MobType.f_21641_;
        }
        if (enchant.m_7335_(level, MobType.f_21642_) > 0.0f && enchant.m_7335_(level, MobType.f_21640_) == 0.0f) {
            return MobType.f_21642_;
        }
        if (enchant.m_7335_(level, MobType.f_21643_) > 0.0f && enchant.m_7335_(level, MobType.f_21640_) == 0.0f) {
            return MobType.f_21643_;
        }
        if (enchant.m_7335_(level, MobType.f_21644_) > 0.0f && enchant.m_7335_(level, MobType.f_21640_) == 0.0f) {
            return MobType.f_21644_;
        }
        if (enchant.m_7335_(level, MobType.f_21640_) > 0.0f) {
            return MobType.f_21640_;
        }
        return null;
    }

    public static ResourceLocation getDefaultTexture(Enchantment.Rarity rarity) {
        return DetailedEnchantments.loc("textures/gui/tooltips/enchantment_" + rarity.name().toLowerCase() + ".png");
    }

    public static ResourceLocation getEnchantmentIcon(ResourceLocation tex, Enchantment.Rarity rarity) {
        ResourceLocation defaultTex = DEUtil.getDefaultTexture(rarity);
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        return resourceManager.m_213713_(tex).isPresent() ? tex : defaultTex;
    }

    public static double getItemAttackDamage(ItemStack stack, MobType targetType) {
        double attributeDamage = DEUtil.getAttributeDamage(stack);
        float enchantmentDamage = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)targetType);
        return attributeDamage + (double)enchantmentDamage;
    }

    public static double getAttributeDamage(ItemStack stack) {
        double damage = 1.0;
        Multimap modifiers = stack.m_41638_(EquipmentSlot.MAINHAND);
        Collection damageModifiers = modifiers.get((Object)Attributes.f_22281_);
        for (AttributeModifier modifier : damageModifiers) {
            double amount = modifier.m_22218_();
            if (modifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                damage += amount;
                continue;
            }
            if (modifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE) {
                damage += damage * amount;
                continue;
            }
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            damage *= 1.0 + amount;
        }
        return damage;
    }

    public static MutableComponent getDescription(Enchantment ench) {
        if (ench == null) {
            return Component.m_237119_();
        }
        return DESCRIPTION_CACHE.computeIfAbsent(ench, e -> {
            String descriptionKey = e.m_44704_() + ".desc";
            if (!I18n.m_118936_((String)descriptionKey) && I18n.m_118936_((String)(e.m_44704_() + ".description"))) {
                descriptionKey = e.m_44704_() + ".description";
            }
            return Component.m_237115_((String)descriptionKey).m_130940_(ChatFormatting.DARK_GRAY);
        });
    }

    public static List<Item> getApplicableItems(Enchantment enchantment) {
        return APPLICABLE_ITEMS_CACHE.computeIfAbsent(enchantment, e -> {
            ArrayList<Item> items = new ArrayList<Item>();
            for (Item item : ForgeRegistries.ITEMS) {
                int i = 0;
                if (i >= 40) {
                    return items;
                }
                if (!e.m_6081_(item.m_7968_())) continue;
                items.add(item);
                ++i;
            }
            return items;
        });
    }
}

