/*
 * Decompiled with CFR 0.152.
 */
package github.iri.detailed_enchantments.core;

import github.iri.detailed_enchantments.core.DEUtil;
import github.iri.detailed_enchantments.core.components.EnchantmentComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentHandler {
    private static final Map<Enchantment, Component> INCOMPATIBILITY_CACHE = new HashMap<Enchantment, Component>();

    public static void handle(GuiGraphics guiGraphics, int mouseX, int mouseY, Enchantment enchantment, int level, ItemStack stack, List<Component> list, ResourceLocation key) {
        MutableComponent descriptionText = DEUtil.getDescription(enchantment);
        ResourceLocation texture = new ResourceLocation(key.m_135827_(), "textures/gui/tooltips/" + key.m_135815_() + ".png");
        Optional<EnchantmentComponent> component = Optional.of(new EnchantmentComponent(descriptionText.m_6881_(), enchantment, level, stack, DEUtil.getEnchantmentIcon(texture, enchantment.m_44699_()), EnchantmentHandler.getCachedIncompatibilities(enchantment)));
        guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, List.of(Component.m_237119_()), component, mouseX, mouseY);
    }

    public static Component getCachedIncompatibilities(Enchantment e) {
        return INCOMPATIBILITY_CACHE.computeIfAbsent(e, key -> {
            MutableComponent comp = Component.m_237119_();
            ArrayList<MutableComponent> names = new ArrayList<MutableComponent>();
            for (Enchantment entry : ForgeRegistries.ENCHANTMENTS) {
                if (key.m_44695_(entry) || key == entry) continue;
                names.add(Component.m_237115_((String)entry.m_44704_()).m_130940_(ChatFormatting.RED));
            }
            if (names.isEmpty()) {
                return Component.m_237119_();
            }
            for (int i = 0; i < names.size(); ++i) {
                comp.m_7220_((Component)names.get(i));
                if (i >= names.size() - 1) continue;
                comp.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.GRAY));
            }
            return comp;
        });
    }
}

