/*
 * Decompiled with CFR 0.152.
 */
package github.iri.detailed_enchantments.core.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import github.iri.detailed_enchantments.core.DEUtil;
import github.iri.detailed_enchantments.core.components.EnchantmentComponent;
import github.iri.detailed_enchantments.core.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import org.joml.Matrix4f;

public class EnchantmentClientComponent
implements ClientTooltipComponent {
    private final ResourceLocation icon;
    private final List<FormattedCharSequence> descriptionLines;
    private final List<FormattedCharSequence> incompatibilityLines;
    private final List<Section> sections = new ArrayList<Section>();
    private final Enchantment enchantment;
    private final Enchantment.Rarity rarity;
    private final int enchLevel;
    private final int maxLevel;
    private final boolean tradeable;
    private final ItemStack itemStack;
    private final int iconSize = (Integer)ClientConfig.ENCHANTMENT_ICON_SIZE.get();
    private final int verticalGap = 6;
    private final int sectionGap = 12;
    private final int statsGap = 8;
    private int totalWidth;
    private int totalHeight;

    public EnchantmentClientComponent(EnchantmentComponent comp) {
        this.icon = comp.icon();
        this.rarity = comp.enchantment().m_44699_();
        this.maxLevel = comp.enchantment().m_6586_();
        this.tradeable = comp.enchantment().m_6594_();
        this.enchantment = comp.enchantment();
        this.enchLevel = comp.level();
        this.itemStack = comp.stack();
        Font font = Minecraft.m_91087_().f_91062_;
        this.descriptionLines = EnchantmentClientComponent.getVisualOrder((Component)comp.description(), comp.description().m_7383_(), font);
        Component incompLabel = comp.incompatibilities();
        this.incompatibilityLines = incompLabel.getString().isEmpty() ? List.of() : EnchantmentClientComponent.getVisualOrder(incompLabel, incompLabel.m_7383_(), font);
        this.computeLayout(font);
    }

    private static List<FormattedCharSequence> getVisualOrder(Component component, Style style, Font font) {
        return Language.m_128107_().m_128112_(font.m_92865_().m_92414_((FormattedText)component, 200, style));
    }

    private void computeLayout(Font font) {
        Enchantment w2;
        boolean showDamage;
        int y = 0;
        ArrayList<Integer> widths = new ArrayList<Integer>();
        this.sections.add(new Section(y, 12, 12, SectionType.NAME));
        widths.add(this.iconSize);
        this.sections.add(new Section(y += 6, this.iconSize, this.iconSize, SectionType.ICON));
        widths.add(this.iconSize);
        int descW = this.measureWidth(font, this.descriptionLines);
        int descH = this.measureHeight(this.descriptionLines);
        this.sections.add(new Section(y += this.iconSize + 6, descH, descW, SectionType.DESCRIPTION));
        y += descH;
        widths.add(descW);
        MobType type = DEUtil.getEnchantmentTarget(this.enchantment, this.enchLevel);
        float bonus = this.enchantment.getDamageBonus(this.enchLevel, type, this.itemStack);
        float base = (float)DEUtil.getItemAttackDamage(this.itemStack, type);
        boolean bl = showDamage = type != null && bonus > 0.0f && base > 1.0f;
        if (showDamage) {
            Component dmg = EnchantmentClientComponent.getDamageComponent(type, base, bonus);
            int w2 = font.m_92852_((FormattedText)dmg);
            this.sections.add(new Section(y, 12, w2, SectionType.DAMAGE));
            y += 12;
            widths.add(w2);
        }
        if ((w2 = this.enchantment) instanceof ProtectionEnchantment) {
            boolean showProtection;
            ProtectionEnchantment protection = (ProtectionEnchantment)w2;
            DamageSource source = DEUtil.getDamageSource(protection);
            int protectionBonus = protection.m_7205_(this.enchLevel, source);
            float baseProtection = 0.0f;
            boolean bl2 = showProtection = protectionBonus > 0;
            if (showProtection) {
                int w3 = font.m_92852_((FormattedText)this.getProtectionComponent(protection, baseProtection, protectionBonus));
                this.sections.add(new Section(y, 12, w3, SectionType.PROTECTION));
                y += 12;
                widths.add(w3);
            }
        }
        if (this.shouldShowStats()) {
            this.sections.add(new Section(y, 2, 100, SectionType.SEPARATOR));
            y += 8;
        }
        int statsW = this.measureStatsWidth(font);
        this.sections.add(new Section(y, 2, statsW, SectionType.STATS));
        y += 12;
        widths.add(statsW);
        if (this.shouldShowIncompats()) {
            int w4 = this.measureWidth(font, this.incompatibilityLines);
            int h = 12 + this.measureHeight(this.incompatibilityLines);
            this.sections.add(new Section(y, h, w4, SectionType.INCOMPATS));
            y += h;
            widths.add(w4);
        }
        this.totalWidth = Math.max(100, widths.stream().max(Integer::compare).orElse(100));
        this.totalHeight = y;
    }

    private int measureWidth(Font font, List<FormattedCharSequence> lines) {
        int w = 0;
        for (FormattedCharSequence l : lines) {
            w = Math.max(w, font.m_92724_(l));
        }
        return w;
    }

    private boolean shouldShowStats() {
        return (Boolean)ClientConfig.SHOW_MAX_LEVEL.get() != false || (Boolean)ClientConfig.SHOW_RARITY.get() != false || (Boolean)ClientConfig.SHOW_TRADE_STATUS.get() != false;
    }

    public int m_142103_() {
        return this.totalHeight;
    }

    public int m_142069_(Font font) {
        return this.totalWidth;
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics g) {
        for (Section s : this.sections) {
            int drawY = y + s.startY();
            this.renderSectionImage(s, x, drawY, g);
        }
    }

    public void m_142440_(Font font, int x, int y, Matrix4f mat, MultiBufferSource.BufferSource buf) {
        for (Section s : this.sections) {
            int drawY = y + s.startY();
            this.renderSectionText(s, x, drawY, font, mat, buf);
        }
    }

    private void renderSectionImage(Section s, int x, int y, GuiGraphics g) {
        switch (s.type) {
            case ICON: {
                int ix = x + (this.totalWidth - this.iconSize) / 2;
                g.m_280163_(this.icon, ix, y, 0.0f, 0.0f, this.iconSize, this.iconSize, this.iconSize, this.iconSize);
                break;
            }
            case SEPARATOR: {
                int mid = x + this.totalWidth / 2;
                int colSolid = -11184811;
                int colClear = 0x555555;
                this.drawHorizontalGradient(g, x, y, mid, y + 1, colClear, colSolid);
                this.drawHorizontalGradient(g, mid, y, x + this.totalWidth, y + 1, colSolid, colClear);
                break;
            }
        }
    }

    private int measureHeight(List<FormattedCharSequence> lines) {
        return lines.size() * 12;
    }

    private int measureStatsWidth(Font font) {
        MutableComponent lvl = Component.m_237110_((String)"detailed_enchantments.max_level", (Object[])new Object[]{this.maxLevel});
        MutableComponent rar = Component.m_237110_((String)"detailed_enchantments.rarity", (Object[])new Object[]{this.rarityName()});
        Component trd = this.getTradeableComponent();
        int w = 0;
        if (((Boolean)ClientConfig.SHOW_RARITY.get()).booleanValue()) {
            w += font.m_92852_((FormattedText)rar);
        }
        if (((Boolean)ClientConfig.SHOW_MAX_LEVEL.get()).booleanValue()) {
            w += (w > 0 ? 8 : 0) + font.m_92852_((FormattedText)lvl);
        }
        if (((Boolean)ClientConfig.SHOW_TRADE_STATUS.get()).booleanValue()) {
            w += (w > 0 ? 8 : 0) + font.m_92852_((FormattedText)trd);
        }
        return w;
    }

    private void renderSectionText(Section s, int x, int y, Font font, Matrix4f mat, MultiBufferSource.BufferSource buf) {
        switch (s.type) {
            case NAME: {
                Component name = this.enchantment.m_44700_(this.enchLevel);
                int centeredX = this.getCenteredX(font, x, name);
                font.m_272077_(name, (float)centeredX, (float)(y - 8), 0xAAAAAA, true, mat, (MultiBufferSource)buf, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                break;
            }
            case DESCRIPTION: {
                int yy = y;
                for (FormattedCharSequence line : this.descriptionLines) {
                    int lx = x + (this.totalWidth - font.m_92724_(line)) / 2;
                    font.m_272191_(line, (float)lx, (float)yy, -1, true, mat, (MultiBufferSource)buf, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    yy += 12;
                }
                break;
            }
            case PROTECTION: {
                Enchantment centeredX = this.enchantment;
                if (!(centeredX instanceof ProtectionEnchantment)) break;
                ProtectionEnchantment protection = (ProtectionEnchantment)centeredX;
                DamageSource source = DEUtil.getDamageSource(protection);
                int protectionBonus = protection.m_7205_(this.enchLevel, source);
                float baseProtection = 0.0f;
                Component prot = this.getProtectionComponent(protection, protectionBonus, baseProtection);
                int lx = x + (this.totalWidth - font.m_92852_((FormattedText)prot)) / 2;
                font.m_272077_(prot, (float)lx, (float)y, 0xAAAAAA, true, mat, (MultiBufferSource)buf, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                break;
            }
            case DAMAGE: {
                MobType type = DEUtil.getEnchantmentTarget(this.enchantment, this.enchLevel);
                float bonus = this.enchantment.getDamageBonus(this.enchLevel, type, this.itemStack);
                float base = (float)DEUtil.getItemAttackDamage(this.itemStack, type);
                Component dmg = EnchantmentClientComponent.getDamageComponent(type, base, bonus);
                int lx = x + (this.totalWidth - font.m_92852_((FormattedText)dmg)) / 2;
                font.m_272077_(dmg, (float)lx, (float)y, 0xAAAAAA, true, mat, (MultiBufferSource)buf, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                break;
            }
            case STATS: {
                MutableComponent rar = Component.m_237110_((String)"detailed_enchantments.rarity", (Object[])new Object[]{this.rarityName()});
                MutableComponent lvl = Component.m_237110_((String)"detailed_enchantments.max_level", (Object[])new Object[]{this.maxLevel});
                Component trd = this.getTradeableComponent();
                int rowW = this.measureStatsWidth(font);
                int drawX = x + (this.totalWidth - rowW) / 2;
                if (((Boolean)ClientConfig.SHOW_RARITY.get()).booleanValue()) {
                    font.m_272077_((Component)rar, (float)drawX, (float)y, this.rarityColor(), true, mat, (MultiBufferSource)buf, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    drawX += font.m_92852_((FormattedText)rar) + 8;
                }
                if (((Boolean)ClientConfig.SHOW_MAX_LEVEL.get()).booleanValue()) {
                    font.m_272077_((Component)lvl, (float)drawX, (float)y, 0xFFAA00, true, mat, (MultiBufferSource)buf, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    drawX += font.m_92852_((FormattedText)lvl) + 8;
                }
                if (!((Boolean)ClientConfig.SHOW_TRADE_STATUS.get()).booleanValue()) break;
                int c = this.tradeable ? 0x55FF55 : 0xFF5555;
                font.m_272077_(trd, (float)drawX, (float)y, c, true, mat, (MultiBufferSource)buf, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                break;
            }
            case INCOMPATS: {
                MutableComponent header = Component.m_237115_((String)"detailed_enchantments.incompatible");
                int hx = x + (this.totalWidth - font.m_92852_((FormattedText)header)) / 2;
                font.m_272077_((Component)header, (float)hx, (float)y, 0xAAAAAA, true, mat, (MultiBufferSource)buf, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                int yy = y + 12;
                for (FormattedCharSequence line : this.incompatibilityLines) {
                    int lx = x + (this.totalWidth - font.m_92724_(line)) / 2;
                    font.m_272191_(line, (float)lx, (float)yy, 0xFF7777, true, mat, (MultiBufferSource)buf, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    yy += 12;
                }
                break;
            }
        }
    }

    private Component rarityName() {
        return DEUtil.getRarity(this.rarity);
    }

    private Component getProtectionComponent(ProtectionEnchantment ench, float base, float bonus) {
        int percentage = (int)base + (int)(bonus * 4.0f);
        return Component.m_237115_((String)"detailed_enchantments.reduction").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)("+" + percentage + "%")).m_130940_(ChatFormatting.BLUE));
    }

    private static Component getDamageComponent(MobType type, float base, float bonus) {
        return Component.m_237110_((String)"detailed_enchantments.damage_bonus", (Object[])new Object[]{DEUtil.getTypeName(type).getString()}).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(base + " -> " + (base + bonus))).m_130940_(ChatFormatting.BLUE));
    }

    private Component getTradeableComponent() {
        return this.tradeable ? Component.m_237115_((String)"detailed_enchantments.tradeable") : Component.m_237115_((String)"detailed_enchantments.not_tradeable");
    }

    private ColorResult color(int c) {
        float a = (float)(c >> 24 & 0xFF) / 255.0f;
        float r = (float)(c >> 16 & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        return new ColorResult(a, r, g, b);
    }

    private int rarityColor() {
        return switch (this.rarity) {
            default -> throw new IncompatibleClassChangeError();
            case Enchantment.Rarity.COMMON -> 14410217;
            case Enchantment.Rarity.UNCOMMON -> 12180939;
            case Enchantment.Rarity.RARE -> 9475839;
            case Enchantment.Rarity.VERY_RARE -> 14395135;
        };
    }

    private int getCenteredX(Font font, int x, Component name) {
        return x + (this.totalWidth - font.m_92852_((FormattedText)name)) / 2;
    }

    private boolean shouldShowIncompats() {
        return !this.incompatibilityLines.isEmpty() && (Boolean)ClientConfig.SHOW_INCOMPATIBILITIES.get() != false;
    }

    private void drawHorizontalGradient(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int colorStart, int colorEnd) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        ColorResult result = this.color(colorStart);
        ColorResult endResult = this.color(colorEnd);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_85950_(endResult.r(), endResult.g(), endResult.b(), endResult.a()).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(result.r(), result.g(), result.b(), result.a()).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_85950_(result.r(), result.g(), result.b(), result.a()).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(endResult.r(), endResult.g(), endResult.b(), endResult.a()).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    private record Section(int startY, int height, int width, SectionType type) {
    }

    private static enum SectionType {
        ICON,
        NAME,
        DESCRIPTION,
        PROTECTION,
        DAMAGE,
        SEPARATOR,
        STATS,
        INCOMPATS;

    }

    private record ColorResult(float a, float r, float g, float b) {
    }
}

