/*
 * Decompiled with CFR 0.152.
 */
package github.iri.detailed_enchantments.core.events;

import com.mojang.datafixers.util.Either;
import github.iri.detailed_enchantments.DetailedEnchantments;
import github.iri.detailed_enchantments.core.DEUtil;
import github.iri.detailed_enchantments.core.components.ItemEnchantmentComponent;
import github.iri.detailed_enchantments.core.config.ClientConfig;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientEvents {
    @SubscribeEvent
    public void onTooltipGatherComponents(RenderTooltipEvent.GatherComponents event) {
        List elements = event.getTooltipElements();
        ItemStack stack = event.getItemStack();
        Map enchMap = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (((Boolean)ClientConfig.ONLY_ENCHANTING_TABLE.get()).booleanValue()) {
            return;
        }
        if (enchMap.isEmpty()) {
            return;
        }
        if (!((Boolean)ClientConfig.SHIFT_FOR_DETAILS.get()).booleanValue() || Screen.m_96638_()) {
            for (Map.Entry entry : enchMap.entrySet()) {
                MutableComponent descriptionText = DEUtil.getDescription((Enchantment)entry.getKey());
                ResourceLocation key = ForgeRegistries.ENCHANTMENTS.getKey((Object)((Enchantment)entry.getKey()));
                if (key == null) continue;
                ResourceLocation texture = new ResourceLocation(key.m_135827_(), "textures/gui/tooltips/" + key.m_135815_() + ".png");
                Enchantment enchantment = (Enchantment)entry.getKey();
                int enchIndex = this.findTextIndex(elements, enchantment.m_44704_());
                int size = ClientEvents.getSize(enchMap);
                if (enchIndex < 0 || enchIndex > elements.size()) continue;
                elements.add(enchIndex + 1, Either.right((Object)new ItemEnchantmentComponent(descriptionText.m_6881_(), enchantment.m_44699_(), texture, 0, size)));
            }
        } else {
            elements.add(1, Either.right((Object)new ItemEnchantmentComponent(Component.m_237115_((String)"detailed_enchantments.shift_for_details").m_130940_(ChatFormatting.DARK_GRAY), Enchantment.Rarity.COMMON, DetailedEnchantments.loc("textures/gui/tooltips/info_box.png"), 0, 10)));
        }
    }

    private int findTextIndex(List<Either<FormattedText, TooltipComponent>> list, String text) {
        for (int i = 0; i < list.size(); ++i) {
            TranslatableContents translatable;
            MutableComponent comp;
            ComponentContents componentContents;
            FormattedText ft;
            Either<FormattedText, TooltipComponent> either = list.get(i);
            if (!either.left().isPresent() || !((ft = (FormattedText)either.left().get()) instanceof MutableComponent) || !((componentContents = (comp = (MutableComponent)ft).m_214077_()) instanceof TranslatableContents) || !(translatable = (TranslatableContents)componentContents).m_237508_().equals(text)) continue;
            return i;
        }
        return -1;
    }

    private static int getSize(Map<Enchantment, Integer> enchList) {
        int size = (Integer)ClientConfig.ICON_SIZE.get();
        if (enchList.size() > (Integer)ClientConfig.ICON_DECREASING_COUNT.get()) {
            size = (Integer)ClientConfig.ICON_SIZE_MIN.get();
        }
        return size;
    }
}

