/*
 * Decompiled with CFR 0.152.
 */
package divinerpg;

import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.MurasamaParticlePacket;
import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.ItemTierRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.RarityRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.item.ToolStats;
import com.idark.valoria.registries.item.armor.item.SamuraiArmorItem;
import com.idark.valoria.registries.item.types.BeastScytheItem;
import com.idark.valoria.registries.item.types.KatanaItem;
import com.idark.valoria.registries.item.types.PhantomItem;
import com.idark.valoria.registries.item.types.ScytheItem;
import com.idark.valoria.registries.item.types.ValoriaSword;
import com.idark.valoria.registries.item.types.curio.CurioAccessoryItem;
import com.idark.valoria.registries.item.types.curio.charm.rune.RuneAccuracy;
import com.idark.valoria.registries.item.types.curio.hands.TalismanItem;
import com.idark.valoria.registries.item.types.elemental.AquariusScytheItem;
import com.idark.valoria.registries.item.types.elemental.CoralReefItem;
import com.idark.valoria.registries.item.types.elemental.InfernalScytheItem;
import com.idark.valoria.registries.item.types.elemental.InfernalSpearItem;
import com.idark.valoria.registries.item.types.elemental.MagmaSwordItem;
import com.idark.valoria.registries.item.types.ranged.CorpseCleaverItem;
import com.idark.valoria.registries.item.types.ranged.ExplosiveSpearItem;
import com.idark.valoria.registries.item.types.ranged.SpearItem;
import com.idark.valoria.registries.item.types.ranged.SpectralBladeItem;
import com.idark.valoria.registries.item.types.ranged.bows.PhantasmBow;
import com.idark.valoria.util.Pal;
import divinerpg.ClientProxy;
import divinerpg.ServerProxy;
import divinerpg.capability.ArcanaProvider;
import divinerpg.capability.TicksEvent;
import divinerpg.client.DivineDashOverlayRender;
import divinerpg.client.ItemModelProperties;
import divinerpg.compat.ModCompat;
import divinerpg.config.ClientConfig;
import divinerpg.config.CommonConfig;
import divinerpg.enums.ArmorStats;
import divinerpg.events.ArcanaRenderer;
import divinerpg.events.AttatchCapabilityEvent;
import divinerpg.events.EventClientLogin;
import divinerpg.events.ForgeEvents;
import divinerpg.events.SpawnEvents;
import divinerpg.items.armor.DivineCrimtaneArmor;
import divinerpg.items.armor.DivineInfernalArmor;
import divinerpg.items.armor.DivinePhantasmArmor;
import divinerpg.items.armor.DivineSpiderArmor;
import divinerpg.items.armor.DivineVoidArmor;
import divinerpg.items.base.DivineFullSetArmor;
import divinerpg.items.base.DivineKatana;
import divinerpg.items.base.EffectFoodItem;
import divinerpg.items.base.ItemDivineArmor;
import divinerpg.items.skins.SkinsRegistry;
import divinerpg.packet.DivineRPGPacketHandler;
import divinerpg.registries.AttributesRegistry;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.CreativeTabRegistry;
import divinerpg.registries.EnchantmentRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.EventRegistry;
import divinerpg.registries.FeatureRegistry;
import divinerpg.registries.FluidRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.LootModifierRegistry;
import divinerpg.registries.MenuTypeRegistry;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.registries.ModVillagerProfession;
import divinerpg.registries.ModVillagerTrades;
import divinerpg.registries.ModelPropRegistry;
import divinerpg.registries.PaintingRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.PlacementModifierRegistry;
import divinerpg.registries.PointOfInterestRegistry;
import divinerpg.registries.PotionRegistry;
import divinerpg.registries.RecipeRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.registries.StructureRegistry;
import divinerpg.util.vanilla.Compostables;
import divinerpg.util.vanilla.LogStripper;
import divinerpg.util.vanilla.PlantPots;
import divinerpg.world.feature.config.JFoliagePlacers;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.common.registry.item.builders.AbstractArmorBuilder;
import pro.komaru.tridot.common.registry.item.skins.ISkinProvider;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;
import pro.komaru.tridot.common.registry.item.skins.SkinRegistryManager;
import pro.komaru.tridot.common.registry.item.types.ConfigurableBowItem;
import pro.komaru.tridot.common.registry.item.types.HitEffectItem;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;

@Mod(value="divinerpg")
@GradleSideOnly(value={GradleSide.SERVER})
public class DivineRPG {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "divinerpg";
    public static final ISidedProxy proxy = FMLEnvironment.dist == Dist.CLIENT ? new ClientProxy() : new ServerProxy();

    public DivineRPG() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        AttributesRegistry.register(bus);
        BlockRegistry.BLOCKS.register(bus);
        ItemRegistry.ITEMS.register(bus);
        JFoliagePlacers.REGISTRY.register(bus);
        BlockRegistry.BLOCK_ITEMS.register(bus);
        BlockEntityRegistry.BLOCK_ENTITIES.register(bus);
        FluidRegistry.FLUIDS.register(bus);
        FluidRegistry.FLUID_TYPES.register(bus);
        MenuTypeRegistry.CONTAINERS.register(bus);
        EntityRegistry.ENTITIES.register(bus);
        SkinRegistryManager.getInstance().registerSkinProvider((ISkinProvider)new SkinsRegistry());
        ParticleRegistry.PARTICLES.register(bus);
        RecipeRegistry.Serailizers.SERIALIZER.register(bus);
        SoundRegistry.SOUNDS.register(bus);
        EnchantmentRegistry.ENCHANTS.register(bus);
        MobEffectRegistry.EFFECTS.register(bus);
        PotionRegistry.POTIONS.register(bus);
        RecipeRegistry.Types.RECIPE_TYPES.register(bus);
        FeatureRegistry.FEATURES.register(bus);
        StructureRegistry.STRUCTURE_TYPE.register(bus);
        PaintingRegistry.PAINTING_VARIANTS.register(bus);
        PointOfInterestRegistry.POI.register(bus);
        LootModifierRegistry.GLOBAL_LOOT_MODIFIERS.register(bus);
        CreativeTabRegistry.TAB.register(bus);
        EventRegistry.init();
        bus.addListener(this::setup);
        bus.addListener(this::post);
        bus.addListener(this::client);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            forgeBus.addListener(DivineDashOverlayRender::tick);
            forgeBus.addListener(DivineDashOverlayRender::onDrawScreenPost);
        }
        bus.addListener(ForgeEvents::populateLists);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, AttatchCapabilityEvent::onAttachCapabilitiesPlayer);
        MinecraftForge.EVENT_BUS.addGenericListener(LevelChunk.class, AttatchCapabilityEvent::onAttachCapabilitiesLevelChunk);
        MinecraftForge.EVENT_BUS.addListener(AttatchCapabilityEvent::onRegisterCapabilities);
        MinecraftForge.EVENT_BUS.addListener(SpawnEvents::spawnPlacementCheck);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEvents());
        MinecraftForge.EVENT_BUS.register((Object)new TicksEvent());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC, "divinerpg/divinerpg-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC, "divinerpg/divinerpg-common.toml");
        ModVillagerProfession.PROFESSIONS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        ModCompat.initCommon(event);
        PlacementModifierRegistry.init();
        DivineRPGPacketHandler.init();
        ModVillagerTrades.register();
        if (!ModList.get().isLoaded("valoria") || !ModList.get().isLoaded("tridot")) {
            throw new IllegalStateException("This mod requires Valoria and Tridot");
        }
        event.enqueueWork(() -> {
            RecipeRegistry.BrewingRecipes.init();
            LogStripper.setup(event);
            PlantPots.setup(event);
            Compostables.setup(event);
        });
    }

    private void client(FMLClientSetupEvent event) {
        ModelPropRegistry.init();
        MenuTypeRegistry.registerScreenFactories();
        BlockEntityRegistry.renderTiles();
        MinecraftForge.EVENT_BUS.register((Object)new ArcanaRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new EventClientLogin());
        ItemModelProperties.makeRage((Item)ItemRegistry.palavence.get());
        ItemModelProperties.makeRage((Item)ItemRegistry.massivence.get());
        ItemModelProperties.makeRage((Item)ItemRegistry.frossivence.get());
        ItemModelProperties.makeRage((Item)ItemRegistry.pativence.get());
        ItemModelProperties.makeRage((Item)ItemRegistry.illusivence.get());
    }

    private void post(FMLLoadCompleteEvent event) {
    }

    private static void registerEffectArmor(RegisterEvent event, String name, ArmorItem.Type type, ArmorMaterial material, Item.Properties props) {
        event.register(ItemsRegistry.ITEMS.getRegistryKey(), new ResourceLocation("valoria", name), () -> new DivineFullSetArmor(material, type, props));
    }

    private static void registerItem(RegisterEvent event, String name, Supplier<Item> item) {
        event.register(ItemsRegistry.ITEMS.getRegistryKey(), new ResourceLocation("valoria", name), item);
    }

    private static void registerVanillaItem(RegisterEvent event, String name, Supplier<Item> item) {
        event.register(ForgeRegistries.ITEMS.getRegistryKey(), new ResourceLocation("minecraft", name), item);
    }

    private static void registerVanillaBlock(RegisterEvent event, String name, Supplier<Block> block) {
        DivineRPG.registerVanillaBlock(event, name, block, Rarity.COMMON);
    }

    private static void registerVanillaBlock(RegisterEvent event, String name, Supplier<Block> block, Rarity rarity) {
        event.register(ForgeRegistries.BLOCKS.getRegistryKey(), new ResourceLocation("minecraft", name), block);
    }

    public static interface ISidedProxy {
        public Player getPlayer();

        public Level getWorld();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerCaps(RegisterEvent event) {
            DivineRPG.registerVanillaItem(event, "golden_apple", () -> new EffectFoodItem(new Item.Properties().m_41497_(Rarity.RARE).m_41486_().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.8f).m_38765_().m_38767_()), new MobEffectInstance(MobEffects.f_19605_, 300, 0), new MobEffectInstance(MobEffects.f_19617_, 300, 0)));
            DivineRPG.registerVanillaItem(event, "enchanted_golden_apple", () -> new EffectFoodItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38765_().m_38758_(0.8f).m_38767_()), new MobEffectInstance[]{new MobEffectInstance((MobEffect)EffectsRegistry.RENEWAL.get(), 160, 1), new MobEffectInstance(MobEffects.f_19605_, 300, 0), new MobEffectInstance(MobEffects.f_19617_, 300, 1)}){

                public boolean m_5812_(@NotNull ItemStack pStack) {
                    return true;
                }
            });
            DivineRPG.registerItem(event, "lesser_rune_of_accuracy", () -> new RuneAccuracy(0.12f, 1.25f, new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON)));
            DivineRPG.registerItem(event, "rune_of_accuracy", () -> new RuneAccuracy(0.18f, 1.21f, new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON)));
            DivineRPG.registerItem(event, "amber_golden_totem", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC)).put(Attributes.f_22276_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.1).build());
            DivineRPG.registerItem(event, "amber_golden_winglet", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC)).put(Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.15).build());
            DivineRPG.registerItem(event, "amber_golden_gazer", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC)).put(Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.05).build());
            DivineRPG.registerItem(event, "emerald_golden_totem", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC)).put(Attributes.f_22276_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.09).put(Attributes.f_22286_, 4.0).build());
            DivineRPG.registerItem(event, "emerald_golden_winglet", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC)).put(Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.1).put(Attributes.f_22286_, 4.0).build());
            DivineRPG.registerItem(event, "emerald_golden_gazer", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC)).put(Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.045).put(Attributes.f_22286_, 4.0).build());
            DivineRPG.registerItem(event, "amethyst_golden_totem", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC)).put(Attributes.f_22276_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.065).put(Attributes.f_22282_, 1.3).build());
            DivineRPG.registerItem(event, "amethyst_golden_winglet", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41503_(-1).m_41497_(Rarity.EPIC)).put(Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.1).put(Attributes.f_22282_, 1.3).build());
            DivineRPG.registerItem(event, "amethyst_golden_gazer", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41503_(-1).m_41497_(Rarity.EPIC)).put(Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.04).put(Attributes.f_22282_, 1.3).build());
            DivineRPG.registerItem(event, "ruby_golden_totem", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41503_(-1).m_41497_(Rarity.EPIC)).put(Attributes.f_22276_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.065).put(Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.075).build());
            DivineRPG.registerItem(event, "ruby_golden_winglet", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41503_(-1).m_41497_(Rarity.EPIC)).put(Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.1).put(Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.075).build());
            DivineRPG.registerItem(event, "ruby_golden_gazer", () -> new TalismanItem.Builder(new Item.Properties().m_41487_(1).m_41503_(-1).m_41497_(Rarity.EPIC)).put(Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.035).put(Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.075).build());
            DivineRPG.registerItem(event, "quantum_reaper", () -> new SwordItem(ItemTierRegistry.NONE, 20, -2.45f, new Item.Properties().m_41497_(RarityRegistry.VOID)){

                public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
                    super.m_7373_(stack, world, tooltip, flags);
                    Utils.Items.addSkinTooltip((ItemStack)stack, tooltip);
                }
            });
            DivineRPG.registerItem(event, "phantom", () -> new PhantomItem(ItemTierRegistry.NONE, 18.5f, -2.4f, new Item.Properties().m_41497_(RarityRegistry.PHANTASM).m_41503_(4096)));
            DivineRPG.registerItem(event, "jade_sword", () -> new ValoriaSword(ItemTierRegistry.JADE, 13.0f, ToolStats.large_sword.speed, new Item.Properties()));
            DivineRPG.registerItem(event, "jade_katana", () -> new KatanaItem.Builder(7.0f, ToolStats.katana.speed, new Item.Properties()).setTier(ItemTierRegistry.JADE).setDashDistance(0.25f).build());
            DivineRPG.registerItem(event, "jade_scythe", () -> new ScytheItem(ItemTierRegistry.JADE, 11.0f, ToolStats.scythe.speed, new Item.Properties()));
            DivineRPG.registerItem(event, "jade_spear", () -> new SpearItem(ItemTierRegistry.JADE, 12.0f, ToolStats.spear.speed, new Item.Properties(), new MobEffectInstance[0]));
            DivineRPG.registerItem(event, "crimtane_axe", () -> new AxeItem(ItemTierRegistry.BLOOD, ToolStats.axe.damage + 8.5f, ToolStats.axe.speed, new Item.Properties().m_41497_(RarityRegistry.BLOODY)));
            DivineRPG.registerItem(event, "crimtane_sword", () -> new ValoriaSword(ItemTierRegistry.BLOOD, 7.3f, ToolStats.sword.speed, new Item.Properties().m_41497_(RarityRegistry.BLOODY)));
            DivineRPG.registerItem(event, "crimtane_scythe", () -> new ScytheItem(ItemTierRegistry.BLOOD, 4.5f, ToolStats.scythe.speed, new Item.Properties().m_41497_(RarityRegistry.BLOODY)));
            DivineRPG.registerItem(event, "meatcutter", () -> new KatanaItem.Builder(12.0f, ToolStats.katana.speed, new Item.Properties().m_41497_(RarityRegistry.BLOODY)).setDashDistance(0.5f).setEffects(0.15f, new MobEffectInstance[]{new MobEffectInstance((MobEffect)EffectsRegistry.EXHAUSTION.get(), 70, 1)}).build());
            DivineRPG.registerItem(event, "corpsecleaver", () -> new CorpseCleaverItem(ItemTierRegistry.BLOOD, 6, -2.4f, new Item.Properties().m_41503_(1151).m_41497_(RarityRegistry.BLOODY)));
            DivineRPG.registerItem(event, "void_spear", () -> new SpearItem(ItemTierRegistry.NIHILITY, 6.0f, ToolStats.spear.speed, new Item.Properties().m_41487_(1).m_41503_(1684).m_41497_(RarityRegistry.VOID), new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_216964_, 90, 0)}));
            DivineRPG.registerItem(event, "pyratite_spear", () -> new ExplosiveSpearItem(ItemTierRegistry.PYRATITE, 9, -2.9f, 28.5f, 0.75f, Level.ExplosionInteraction.NONE, new Item.Properties().m_41497_(RarityRegistry.INFERNAL), new MobEffectInstance[0]));
            DivineRPG.registerItem(event, "ethereal_sword", () -> new SwordItem(ItemTierRegistry.ETHEREAL, 17, -2.4f, new Item.Properties().m_41497_(RarityRegistry.ETHEREAL)));
            DivineRPG.registerItem(event, "ethereal_spear", () -> new SpearItem(ItemTierRegistry.ETHEREAL, 11.0f, -3.0f, 6.0f, new Item.Properties().m_41497_(RarityRegistry.ETHEREAL), new MobEffectInstance[0]));
            DivineRPG.registerItem(event, "ethereal_pickaxe", () -> new PickaxeItem(ItemTierRegistry.ETHEREAL, 9, -3.0f, new Item.Properties().m_41497_(RarityRegistry.ETHEREAL)));
            DivineRPG.registerItem(event, "ethereal_axe", () -> new AxeItem(ItemTierRegistry.ETHEREAL, 16.0f, -2.8f, new Item.Properties().m_41497_(RarityRegistry.ETHEREAL)));
            DivineRPG.registerItem(event, "spectral_blade", () -> new SpectralBladeItem(20, 2.0f, new Item.Properties().m_41503_(512).m_41497_(RarityRegistry.PHANTASM)));
            DivineRPG.registerItem(event, "soul_reaver", () -> new HitEffectItem(ItemTierRegistry.HALLOWEEN, 20.0f, -2.6f, new Item.Properties().m_41497_(RarityRegistry.HALLOWEEN), 0.25f, new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_216964_, 40, 0), new MobEffectInstance(MobEffects.f_19613_, 60, 1)}));
            DivineRPG.registerItem(event, "dread_axe", () -> new AxeItem(ItemTierRegistry.HALLOWEEN, 20.5f, -2.8f, new Item.Properties().m_41497_(RarityRegistry.HALLOWEEN)));
            DivineRPG.registerItem(event, "void_edge", () -> new SwordItem(ItemTierRegistry.NIHILITY, 6, -2.5f, new Item.Properties().m_41497_(RarityRegistry.VOID)));
            DivineRPG.registerItem(event, "void_axe", () -> new AxeItem(ItemTierRegistry.NIHILITY, 6.0f, -2.9f, new Item.Properties().m_41486_().m_41497_(RarityRegistry.VOID)));
            DivineRPG.registerItem(event, "infernal_sword", () -> new MagmaSwordItem(ItemTierRegistry.INFERNAL, 10.0f, -2.5f, new Item.Properties().m_41486_().m_41497_(RarityRegistry.INFERNAL)));
            DivineRPG.registerItem(event, "infernal_axe", () -> new AxeItem(ItemTierRegistry.INFERNAL, 11.5f, -2.8f, new Item.Properties().m_41486_().m_41497_(RarityRegistry.INFERNAL)));
            DivineRPG.registerItem(event, "coral_reef", () -> new CoralReefItem(ItemTierRegistry.AQUARIUS, 11.0f, -2.4f, new Item.Properties().m_41497_(RarityRegistry.AQUARIUS)));
            DivineRPG.registerItem(event, "aquarius_axe", () -> new AxeItem(ItemTierRegistry.AQUARIUS, 12.5f, -2.8f, new Item.Properties().m_41497_(RarityRegistry.AQUARIUS)));
            DivineRPG.registerItem(event, "ent", () -> new SwordItem(ItemTierRegistry.NATURE, 11, -2.5f, new Item.Properties().m_41497_(RarityRegistry.NATURE)));
            DivineRPG.registerItem(event, "nature_axe", () -> new AxeItem(ItemTierRegistry.NATURE, 15.0f, -2.8f, new Item.Properties().m_41497_(RarityRegistry.NATURE)));
            DivineRPG.registerItem(event, "silken_blade", () -> new HitEffectItem(ItemTierRegistry.NONE, 18.0f, -2.5f, new Item.Properties(), 0.25f, new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_216964_, 120, 0), new MobEffectInstance(MobEffects.f_19614_, 45, 0)}));
            DivineRPG.registerItem(event, "holiday_katana", () -> new KatanaItem(ItemTierRegistry.HOLIDAY, 21.0f, -2.2f, new Item.Properties()));
            DivineRPG.registerItem(event, "holiday_axe", () -> new AxeItem(ItemTierRegistry.HOLIDAY, 24.0f, -3.0f, new Item.Properties()));
            DivineRPG.registerItem(event, "silken_wakizashi", () -> new DivineKatana.Builder(20, -2.2f, new Item.Properties()).setTimeToCharge(10).setDashDistance(0.5f).removeLargeModelCheck().setEffects(0.25f, new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_216964_, 120, 0), new MobEffectInstance(MobEffects.f_19614_, 45, 0)}).build());
            DivineRPG.registerItem(event, "iron_katana", () -> new DivineKatana.Builder(4, -2.2f, new Item.Properties()).setTimeToCharge(7).setDashDistance(0.15f).build());
            DivineRPG.registerItem(event, "golden_katana", () -> new DivineKatana.Builder(2, -2.2f, new Item.Properties()).setTimeToCharge(5).setDashDistance(0.5f).build());
            DivineRPG.registerItem(event, "diamond_katana", () -> new DivineKatana.Builder(5, -2.2f, new Item.Properties()).setTimeToCharge(10).setDashDistance(0.36f).build());
            DivineRPG.registerItem(event, "netherite_katana", () -> new DivineKatana.Builder(15, -2.2f, new Item.Properties()).setTimeToCharge(12).setDashDistance(0.85f).build());
            DivineRPG.registerItem(event, "wraith_katana", () -> new DivineKatana.Builder(23, -2.2f, new Item.Properties().m_41497_(RarityRegistry.HALLOWEEN)).setTimeToCharge(12).setTier(ItemTierRegistry.HALLOWEEN).removeLargeModelCheck().setDashDistance(0.65f).setDashSound((SoundEvent)SoundsRegistry.HALLOWEEN_SLICE.get()).setOverlay(new ResourceLocation("valoria", "textures/gui/overlay/roots.png")).usePacket(Pal.mandarin.toJava()).build());
            DivineRPG.registerItem(event, "samurai_katana", () -> new DivineKatana(ItemTierRegistry.SAMURAI, 16, -2.0f, new Item.Properties()));
            DivineRPG.registerItem(event, "murasama", RegistryEvents::murasamaProps);
            DivineRPG.registerItem(event, "reaper_scythe", () -> new ScytheItem.Builder(21.0f, -3.0f, new Item.Properties().m_41486_().m_41497_(RarityRegistry.HALLOWEEN)).setEffects(0.5f, new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_216964_, 90, 0)}).setAttackSound((SoundEvent)SoundsRegistry.HALLOWEEN_SLICE.get()).setTier(ItemTierRegistry.HALLOWEEN).build());
            DivineRPG.registerItem(event, "beast", () -> new BeastScytheItem.Builder(19.0f, -3.2f, new Item.Properties()).setTier(ItemTierRegistry.NONE).setCooldownTime(40, 150).build());
            DivineRPG.registerItem(event, "netherite_scythe", () -> new ScytheItem((Tier)Tiers.NETHERITE, 8.0f, -3.0f, new Item.Properties().m_41486_()));
            DivineRPG.registerItem(event, "nature_scythe", () -> new ScytheItem(ItemTierRegistry.NATURE, 8.0f, -3.0f, new Item.Properties().m_41497_(RarityRegistry.NATURE)));
            DivineRPG.registerItem(event, "aquarius_scythe", () -> new AquariusScytheItem(ItemTierRegistry.AQUARIUS, 8.0f, -3.0f, new Item.Properties().m_41497_(RarityRegistry.AQUARIUS)));
            DivineRPG.registerItem(event, "infernal_scythe", () -> new InfernalScytheItem(ItemTierRegistry.INFERNAL, 8.0f, -3.0f, new Item.Properties().m_41486_().m_41497_(RarityRegistry.INFERNAL)));
            DivineRPG.registerItem(event, "void_scythe", () -> new ScytheItem.Builder(5.0f, -3.0f, new Item.Properties().m_41486_().m_41497_(RarityRegistry.VOID)).setTier(ItemTierRegistry.NIHILITY).setEffects(0.35f, new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_216964_, 90, 0), new MobEffectInstance(MobEffects.f_19613_, 50, 3)}).build());
            DivineRPG.registerItem(event, "infernal_spear", () -> new InfernalSpearItem(ItemTierRegistry.INFERNAL, ToolStats.spear.damage + 13.0f, ToolStats.spear.speed, new Item.Properties().m_41486_().m_41487_(1).m_41503_(1684).m_41497_(RarityRegistry.INFERNAL), new MobEffectInstance[0]));
            DivineRPG.registerItem(event, "cobalt_helmet", () -> new ItemDivineArmor((ArmorMaterial)ArmorStats.COBALT, ArmorItem.Type.HELMET));
            DivineRPG.registerItem(event, "cobalt_chestplate", () -> new ItemDivineArmor((ArmorMaterial)ArmorStats.COBALT, ArmorItem.Type.CHESTPLATE));
            DivineRPG.registerItem(event, "cobalt_leggings", () -> new ItemDivineArmor((ArmorMaterial)ArmorStats.COBALT, ArmorItem.Type.LEGGINGS));
            DivineRPG.registerItem(event, "cobalt_boots", () -> new ItemDivineArmor((ArmorMaterial)ArmorStats.COBALT, ArmorItem.Type.BOOTS));
            DivineRPG.registerItem(event, "samurai_kabuto", () -> new SamuraiArmorItem((ArmorMaterial)ArmorStats.SAMURAI, ArmorItem.Type.HELMET, new Item.Properties()));
            DivineRPG.registerItem(event, "samurai_chestplate", () -> new SamuraiArmorItem((ArmorMaterial)ArmorStats.SAMURAI, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
            DivineRPG.registerItem(event, "samurai_leggings", () -> new SamuraiArmorItem((ArmorMaterial)ArmorStats.SAMURAI, ArmorItem.Type.LEGGINGS, new Item.Properties()));
            DivineRPG.registerItem(event, "samurai_boots", () -> new SamuraiArmorItem((ArmorMaterial)ArmorStats.SAMURAI, ArmorItem.Type.BOOTS, new Item.Properties()));
            DivineRPG.registerEffectArmor(event, "nature_helmet", ArmorItem.Type.HELMET, (ArmorMaterial)ArmorStats.NATURE, new Item.Properties().m_41497_(RarityRegistry.NATURE));
            DivineRPG.registerEffectArmor(event, "nature_chestplate", ArmorItem.Type.CHESTPLATE, (ArmorMaterial)ArmorStats.NATURE, new Item.Properties().m_41497_(RarityRegistry.NATURE));
            DivineRPG.registerEffectArmor(event, "nature_leggings", ArmorItem.Type.LEGGINGS, (ArmorMaterial)ArmorStats.NATURE, new Item.Properties().m_41497_(RarityRegistry.NATURE));
            DivineRPG.registerEffectArmor(event, "nature_boots", ArmorItem.Type.BOOTS, (ArmorMaterial)ArmorStats.NATURE, new Item.Properties().m_41497_(RarityRegistry.NATURE));
            DivineRPG.registerEffectArmor(event, "depth_helmet", ArmorItem.Type.HELMET, (ArmorMaterial)ArmorStats.DEPTH, new Item.Properties().m_41497_(RarityRegistry.AQUARIUS));
            DivineRPG.registerEffectArmor(event, "depth_chestplate", ArmorItem.Type.CHESTPLATE, (ArmorMaterial)ArmorStats.DEPTH, new Item.Properties().m_41497_(RarityRegistry.AQUARIUS));
            DivineRPG.registerEffectArmor(event, "depth_leggings", ArmorItem.Type.LEGGINGS, (ArmorMaterial)ArmorStats.DEPTH, new Item.Properties().m_41497_(RarityRegistry.AQUARIUS));
            DivineRPG.registerEffectArmor(event, "depth_boots", ArmorItem.Type.BOOTS, (ArmorMaterial)ArmorStats.DEPTH, new Item.Properties().m_41497_(RarityRegistry.AQUARIUS));
            DivineRPG.registerItem(event, "infernal_helmet", () -> new DivineInfernalArmor(ArmorItem.Type.HELMET, (ArmorMaterial)ArmorStats.INFERNAL, new Item.Properties().m_41497_(RarityRegistry.INFERNAL).m_41486_()));
            DivineRPG.registerItem(event, "infernal_chestplate", () -> new DivineInfernalArmor(ArmorItem.Type.CHESTPLATE, (ArmorMaterial)ArmorStats.INFERNAL, new Item.Properties().m_41497_(RarityRegistry.INFERNAL).m_41486_()));
            DivineRPG.registerItem(event, "infernal_leggings", () -> new DivineInfernalArmor(ArmorItem.Type.LEGGINGS, (ArmorMaterial)ArmorStats.INFERNAL, new Item.Properties().m_41497_(RarityRegistry.INFERNAL).m_41486_()));
            DivineRPG.registerItem(event, "infernal_boots", () -> new DivineInfernalArmor(ArmorItem.Type.BOOTS, (ArmorMaterial)ArmorStats.INFERNAL, new Item.Properties().m_41497_(RarityRegistry.INFERNAL).m_41486_()));
            DivineRPG.registerItem(event, "awakened_void_helmet", () -> new DivineVoidArmor(ArmorItem.Type.HELMET, (ArmorMaterial)ArmorStats.VOID, new Item.Properties().m_41497_(RarityRegistry.VOID).m_41486_()));
            DivineRPG.registerItem(event, "awakened_void_chestplate", () -> new DivineVoidArmor(ArmorItem.Type.CHESTPLATE, (ArmorMaterial)ArmorStats.VOID, new Item.Properties().m_41497_(RarityRegistry.VOID).m_41486_()));
            DivineRPG.registerItem(event, "awakened_void_leggings", () -> new DivineVoidArmor(ArmorItem.Type.LEGGINGS, (ArmorMaterial)ArmorStats.VOID, new Item.Properties().m_41497_(RarityRegistry.VOID).m_41486_()));
            DivineRPG.registerItem(event, "awakened_void_boots", () -> new DivineVoidArmor(ArmorItem.Type.BOOTS, (ArmorMaterial)ArmorStats.VOID, new Item.Properties().m_41497_(RarityRegistry.VOID).m_41486_()));
            DivineRPG.registerItem(event, "spider_helmet", () -> new DivineSpiderArmor((ArmorMaterial)ArmorStats.SPIDER, ArmorItem.Type.HELMET, new Item.Properties().m_41497_(RarityRegistry.SPIDER), 0.2f, new MobEffectInstance(MobEffects.f_19613_, 20)));
            DivineRPG.registerItem(event, "spider_chestplate", () -> new DivineSpiderArmor((ArmorMaterial)ArmorStats.SPIDER, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41497_(RarityRegistry.SPIDER), 0.1f, new MobEffectInstance(MobEffects.f_19610_, 40)));
            DivineRPG.registerItem(event, "spider_leggings", () -> new DivineSpiderArmor((ArmorMaterial)ArmorStats.SPIDER, ArmorItem.Type.LEGGINGS, new Item.Properties().m_41497_(RarityRegistry.SPIDER), 0.3f, new MobEffectInstance(MobEffects.f_19597_, 35)));
            DivineRPG.registerItem(event, "spider_boots", () -> new DivineSpiderArmor((ArmorMaterial)ArmorStats.SPIDER, ArmorItem.Type.BOOTS, new Item.Properties().m_41497_(RarityRegistry.SPIDER), 0.2f, new MobEffectInstance(MobEffects.f_19604_, 30)));
            DivineRPG.registerItem(event, "phantasm_helmet", () -> new DivinePhantasmArmor((ArmorMaterial)ArmorStats.PHANTASM, ArmorItem.Type.HELMET, new Item.Properties().m_41497_(RarityRegistry.PHANTASM).m_41486_()));
            DivineRPG.registerItem(event, "phantasm_chestplate", () -> new DivinePhantasmArmor((ArmorMaterial)ArmorStats.PHANTASM, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41497_(RarityRegistry.PHANTASM).m_41486_()));
            DivineRPG.registerItem(event, "phantasm_leggings", () -> new DivinePhantasmArmor((ArmorMaterial)ArmorStats.PHANTASM, ArmorItem.Type.LEGGINGS, new Item.Properties().m_41497_(RarityRegistry.PHANTASM).m_41486_()));
            DivineRPG.registerItem(event, "phantasm_boots", () -> new DivinePhantasmArmor((ArmorMaterial)ArmorStats.PHANTASM, ArmorItem.Type.BOOTS, new Item.Properties().m_41497_(RarityRegistry.PHANTASM).m_41486_()));
            DivineRPG.registerItem(event, "pyratite_helmet", () -> new DivineFullSetArmor((ArmorMaterial)ArmorStats.PYRATITE, ArmorItem.Type.HELMET, new Item.Properties().m_41486_().m_41497_(RarityRegistry.PYRATITE)){

                @Override
                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
                    super.m_7373_(stack, level, tooltip, flag);
                    RegistryEvents.pyratiteAdditionalInfo(tooltip);
                }
            });
            DivineRPG.registerItem(event, "pyratite_chestplate", () -> new DivineFullSetArmor((ArmorMaterial)ArmorStats.PYRATITE, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41486_().m_41497_(RarityRegistry.PYRATITE)){

                @Override
                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
                    super.m_7373_(stack, level, tooltip, flag);
                    RegistryEvents.pyratiteAdditionalInfo(tooltip);
                }
            });
            DivineRPG.registerItem(event, "pyratite_leggings", () -> new DivineFullSetArmor((ArmorMaterial)ArmorStats.PYRATITE, ArmorItem.Type.LEGGINGS, new Item.Properties().m_41486_().m_41497_(RarityRegistry.PYRATITE)){

                @Override
                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
                    super.m_7373_(stack, level, tooltip, flag);
                    RegistryEvents.pyratiteAdditionalInfo(tooltip);
                }
            });
            DivineRPG.registerItem(event, "pyratite_boots", () -> new DivineFullSetArmor((ArmorMaterial)ArmorStats.PYRATITE, ArmorItem.Type.BOOTS, new Item.Properties().m_41486_().m_41497_(RarityRegistry.PYRATITE)){

                @Override
                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
                    super.m_7373_(stack, level, tooltip, flag);
                    RegistryEvents.pyratiteAdditionalInfo(tooltip);
                }
            });
            DivineRPG.registerItem(event, "crimtane_helmet", () -> new DivineCrimtaneArmor((ArmorMaterial)ArmorStats.CRIMTANE, ArmorItem.Type.HELMET, new Item.Properties().m_41497_(RarityRegistry.BLOODY)));
            DivineRPG.registerItem(event, "crimtane_chestplate", () -> new DivineCrimtaneArmor((ArmorMaterial)ArmorStats.CRIMTANE, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41497_(RarityRegistry.BLOODY)));
            DivineRPG.registerItem(event, "crimtane_leggings", () -> new DivineCrimtaneArmor((ArmorMaterial)ArmorStats.CRIMTANE, ArmorItem.Type.LEGGINGS, new Item.Properties().m_41497_(RarityRegistry.BLOODY)));
            DivineRPG.registerItem(event, "crimtane_boots", () -> new DivineCrimtaneArmor((ArmorMaterial)ArmorStats.CRIMTANE, ArmorItem.Type.BOOTS, new Item.Properties().m_41497_(RarityRegistry.BLOODY)));
            DivineRPG.registerEffectArmor(event, "ethereal_helmet", ArmorItem.Type.HELMET, (ArmorMaterial)ArmorStats.ETHEREAL, new Item.Properties().m_41497_(RarityRegistry.ETHEREAL));
            DivineRPG.registerEffectArmor(event, "ethereal_chestplate", ArmorItem.Type.CHESTPLATE, (ArmorMaterial)ArmorStats.ETHEREAL, new Item.Properties().m_41497_(RarityRegistry.ETHEREAL));
            DivineRPG.registerEffectArmor(event, "ethereal_leggings", ArmorItem.Type.LEGGINGS, (ArmorMaterial)ArmorStats.ETHEREAL, new Item.Properties().m_41497_(RarityRegistry.ETHEREAL));
            DivineRPG.registerEffectArmor(event, "ethereal_boots", ArmorItem.Type.BOOTS, (ArmorMaterial)ArmorStats.ETHEREAL, new Item.Properties().m_41497_(RarityRegistry.ETHEREAL));
            DivineRPG.registerVanillaItem(event, "turtle_helmet", () -> new DivineFullSetArmor(ArmorStats.TURTLE, ArmorItem.Type.HELMET));
            DivineRPG.registerVanillaItem(event, "chainmail_helmet", () -> new DivineFullSetArmor(ArmorStats.CHAIN, ArmorItem.Type.HELMET));
            DivineRPG.registerVanillaItem(event, "chainmail_chestplate", () -> new DivineFullSetArmor(ArmorStats.CHAIN, ArmorItem.Type.CHESTPLATE));
            DivineRPG.registerVanillaItem(event, "chainmail_leggings", () -> new DivineFullSetArmor(ArmorStats.CHAIN, ArmorItem.Type.LEGGINGS));
            DivineRPG.registerVanillaItem(event, "chainmail_boots", () -> new DivineFullSetArmor(ArmorStats.CHAIN, ArmorItem.Type.BOOTS));
            DivineRPG.registerVanillaItem(event, "golden_helmet", () -> new DivineFullSetArmor(ArmorStats.GOLD, ArmorItem.Type.HELMET));
            DivineRPG.registerVanillaItem(event, "golden_chestplate", () -> new DivineFullSetArmor(ArmorStats.GOLD, ArmorItem.Type.CHESTPLATE));
            DivineRPG.registerVanillaItem(event, "golden_leggings", () -> new DivineFullSetArmor(ArmorStats.GOLD, ArmorItem.Type.LEGGINGS));
            DivineRPG.registerVanillaItem(event, "golden_boots", () -> new DivineFullSetArmor(ArmorStats.GOLD, ArmorItem.Type.BOOTS));
            DivineRPG.registerVanillaItem(event, "iron_helmet", () -> new DivineFullSetArmor(ArmorStats.IRON, ArmorItem.Type.HELMET));
            DivineRPG.registerVanillaItem(event, "iron_chestplate", () -> new DivineFullSetArmor(ArmorStats.IRON, ArmorItem.Type.CHESTPLATE));
            DivineRPG.registerVanillaItem(event, "iron_leggings", () -> new DivineFullSetArmor(ArmorStats.IRON, ArmorItem.Type.LEGGINGS));
            DivineRPG.registerVanillaItem(event, "iron_boots", () -> new DivineFullSetArmor(ArmorStats.IRON, ArmorItem.Type.BOOTS));
            DivineRPG.registerVanillaItem(event, "diamond_helmet", () -> new DivineFullSetArmor(ArmorStats.DIAMOND, ArmorItem.Type.HELMET));
            DivineRPG.registerVanillaItem(event, "diamond_chestplate", () -> new DivineFullSetArmor(ArmorStats.DIAMOND, ArmorItem.Type.CHESTPLATE));
            DivineRPG.registerVanillaItem(event, "diamond_leggings", () -> new DivineFullSetArmor(ArmorStats.DIAMOND, ArmorItem.Type.LEGGINGS));
            DivineRPG.registerVanillaItem(event, "diamond_boots", () -> new DivineFullSetArmor(ArmorStats.DIAMOND, ArmorItem.Type.BOOTS));
            DivineRPG.registerVanillaItem(event, "netherite_helmet", () -> new DivineFullSetArmor(ArmorStats.NETHERITE, ArmorItem.Type.HELMET));
            DivineRPG.registerVanillaItem(event, "netherite_chestplate", () -> new DivineFullSetArmor(ArmorStats.NETHERITE, ArmorItem.Type.CHESTPLATE));
            DivineRPG.registerVanillaItem(event, "netherite_leggings", () -> new DivineFullSetArmor(ArmorStats.NETHERITE, ArmorItem.Type.LEGGINGS));
            DivineRPG.registerVanillaItem(event, "netherite_boots", () -> new DivineFullSetArmor(ArmorStats.NETHERITE, ArmorItem.Type.BOOTS));
            DivineRPG.registerVanillaBlock(event, "end_portal_frame", () -> new EndPortalFrameBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56744_).m_60913_(4.0f, 5.0f)));
            DivineRPG.registerItem(event, "samurai_long_bow", () -> new ConfigurableBowItem(5.25, new Item.Properties().m_41487_(1).m_41503_(684)));
            DivineRPG.registerItem(event, "nature_bow", () -> new ConfigurableBowItem(3.5, new Item.Properties().m_41487_(1).m_41503_(1024).m_41497_(RarityRegistry.NATURE)));
            DivineRPG.registerItem(event, "aquarius_bow", () -> new ConfigurableBowItem(4.0, new Item.Properties().m_41487_(1).m_41503_(1324).m_41486_().m_41497_(RarityRegistry.AQUARIUS)));
            DivineRPG.registerItem(event, "infernal_bow", () -> new ConfigurableBowItem((Supplier)EntityTypeRegistry.INFERNAL_ARROW, 4.0, 3, new Item.Properties().m_41486_().m_41487_(1).m_41503_(1684).m_41497_(RarityRegistry.INFERNAL)));
            DivineRPG.registerItem(event, "bow_of_darkness", () -> new ConfigurableBowItem(6.15, new Item.Properties().m_41487_(1).m_41503_(2048).m_41486_().m_41497_(RarityRegistry.VOID)));
            DivineRPG.registerItem(event, "phantasm_bow", () -> new PhantasmBow(6.75, 3, new Item.Properties().m_41487_(1).m_41503_(4024).m_41497_(RarityRegistry.PHANTASM)));
            DivineRPG.registerItem(event, "leather_belt", () -> ((CurioAccessoryItem.Builder)((CurioAccessoryItem.Builder)new CurioAccessoryItem.Builder(ItemTierRegistry.NONE, new Item.Properties().m_41487_(1).m_41503_(250).m_41497_(Rarity.COMMON)).setTexPath(new ResourceLocation("valoria", "textures/curio/body/"))).addAttr(() -> Attributes.f_22278_, new AbstractArmorBuilder.AttributeData(0.05f, AttributeModifier.Operation.MULTIPLY_BASE))).build());
        }

        private static void pyratiteAdditionalInfo(List<Component> tooltip) {
            tooltip.add((Component)Component.m_237113_((String)"\u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u044d\u0444\u0444\u0435\u043a\u0442\u044b \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0438 \u0433\u043e\u0440\u0435\u043d\u0438\u0438").m_130940_(ChatFormatting.GRAY));
        }

        public static DivineKatana murasamaProps() {
            return new DivineKatana(ItemTierRegistry.SAMURAI, 22, -2.1f, new Item.Properties()){
                {
                    this.builder.chargeTime = 11;
                    this.builder.dashDist = 0.85f;
                }

                @Override
                public void m_5929_(@NotNull Level worldIn, @NotNull LivingEntity livingEntityIn, @NotNull ItemStack stack, int count) {
                    Player player = (Player)livingEntityIn;
                    if (worldIn instanceof ServerLevel) {
                        ServerLevel srv = (ServerLevel)worldIn;
                        ItemSkin skin = ItemSkin.itemSkin((ItemStack)stack);
                        Color color = skin != null ? skin.color().toJava() : new Color(235, 0, 25);
                        for (int ii = 0; ii < 1 + Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)0, (int)2); ++ii) {
                            PacketHandler.sendToTracking((Level)srv, (BlockPos)player.m_20097_(), (Object)new MurasamaParticlePacket(3.0f, player.m_20185_(), player.m_20186_() + (double)(player.m_20192_() / 2.0f), player.m_20189_(), color.getRed(), color.getGreen(), color.getBlue()));
                        }
                    }
                    if (player.m_21252_() == this.builder.chargeTime) {
                        if (this.builder.chargedSound != null) {
                            player.m_6330_(this.builder.chargedSound, SoundSource.PLAYERS, 0.25f, 1.0f);
                        }
                        RandomSource rand = worldIn.m_213780_();
                        Vector3d pos = new Vector3d(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
                        player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                            if (arcana.getAmount(false) >= 45.0f) {
                                arcana.consume(player, 45.0f);
                                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                                this.applyCooldown(player);
                                worldIn.m_5594_(null, player.m_20097_(), this.builder.dashSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                                player.m_5810_();
                                this.performDash(stack, worldIn, player, pos, rand);
                            }
                        });
                    }
                }
            };
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void attachAttribute(EntityAttributeModificationEvent event) {
            event.add(EntityType.f_20532_, (Attribute)AttributesRegistry.ARCANA_MAX.get());
            event.add(EntityType.f_20532_, (Attribute)AttributesRegistry.ARCANA_REGEN.get());
            event.add((EntityType)EntityTypeRegistry.SHADEWOOD_SPIDER.get(), Attributes.f_22281_, 35.0);
            event.add((EntityType)EntityTypeRegistry.SHADEWOOD_SPIDER.get(), Attributes.f_22276_, 475.0);
            event.add((EntityType)EntityTypeRegistry.FLESH_SENTINEL.get(), Attributes.f_22281_, 35.0);
            event.add((EntityType)EntityTypeRegistry.FLESH_SENTINEL.get(), Attributes.f_22276_, 285.0);
            event.add((EntityType)EntityTypeRegistry.CORRUPTED_TROLL.get(), Attributes.f_22281_, 32.0);
            event.add((EntityType)EntityTypeRegistry.CORRUPTED_TROLL.get(), Attributes.f_22276_, 535.0);
            event.add((EntityType)EntityTypeRegistry.WICKED_CRYSTAL.get(), Attributes.f_22276_, 10000.0);
            event.add((EntityType)EntityTypeRegistry.CRYSTAL.get(), Attributes.f_22276_, 375.0);
            event.add((EntityType)EntityTypeRegistry.CRYSTAL.get(), Attributes.f_22276_, 375.0);
            event.add((EntityType)EntityTypeRegistry.WICKED_SHIELD.get(), Attributes.f_22276_, 456.0);
            event.add((EntityType)EntityTypeRegistry.CORRUPTED.get(), Attributes.f_22276_, 460.0);
            event.add((EntityType)EntityTypeRegistry.CORRUPTED.get(), Attributes.f_22281_, 33.0);
        }
    }
}

