/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.block.types.UmbralBlock;
import com.idark.valoria.registries.block.types.UmbralKeyPadBlock;
import com.idark.valoria.registries.entity.living.DraugrEntity;
import divinerpg.entities.boss.EntityPossessedVikingArmor;
import divinerpg.entities.valoria.EntityTaintedKnight;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.scheduling.AoAScheduler;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SoulTrapBlockEntity
extends BlockEntity {
    private int wave = 1;
    public final Set<Mob> currentWaveMobs = new HashSet<Mob>();

    public SoulTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.SOUL_TRAP.get(), pos, state);
    }

    public void summonWave(ServerLevel world, BlockPos pos, Random random) {
        int knightCount = 3;
        int skeletonCount = 0;
        int radius = 12;
        if (this.wave == 2) {
            knightCount = 5;
        } else if (this.wave == 3) {
            knightCount = 3;
            skeletonCount = 5;
        } else if (this.wave == 4) {
            AoAScheduler.scheduleAsyncTask(() -> this.summonBoss(world, pos), 5, TimeUnit.SECONDS);
            knightCount = 3;
            skeletonCount = 1;
        }
        this.summonKnights(world, pos, random, knightCount);
        if (skeletonCount > 0) {
            this.summonDraugrs(world, pos, random, skeletonCount);
        }
        for (BlockPos searchPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-radius, -radius, -radius), (BlockPos)pos.m_7918_(radius, radius, radius))) {
            BlockState blockState = this.m_58904_().m_8055_(searchPos);
            if (blockState.m_60713_((Block)BlockRegistry.umbralBlock.get())) {
                this.m_58904_().m_7731_(searchPos, (BlockState)((BlockState)blockState.m_61124_((Property)UmbralBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UmbralBlock.RETURN, (Comparable)Boolean.valueOf(false)), 3);
                continue;
            }
            if (!blockState.m_60713_((Block)BlockRegistry.umbralKeypad.get())) continue;
            this.m_58904_().m_7731_(searchPos, (BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)UmbralKeyPadBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UmbralKeyPadBlock.KEY_CLICKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UmbralKeyPadBlock.RETURN, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private void summonKnights(ServerLevel world, BlockPos pos, Random random, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 spawnPos = this.getRandomPositionAround(pos, random);
            EntityTaintedKnight knight = new EntityTaintedKnight((EntityType<? extends Monster>)((EntityType)EntityRegistry.TAINTED_KNIGHT.get()), (Level)world);
            knight.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0f, 0.0f);
            knight.m_20049_("wave_mob");
            this.currentWaveMobs.add((Mob)knight);
            world.m_7967_((Entity)knight);
        }
    }

    private void summonDraugrs(ServerLevel world, BlockPos pos, Random random, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 spawnPos = this.getRandomPositionAround(pos, random);
            DraugrEntity draugr = new DraugrEntity((EntityType)EntityTypeRegistry.DRAUGR.get(), (Level)world);
            draugr.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0f, 0.0f);
            draugr.m_21051_(Attributes.f_22281_).m_22100_(draugr.m_21172_(Attributes.f_22281_) + 32.0);
            draugr.m_21051_(Attributes.f_22276_).m_22100_(325.0);
            draugr.m_21153_(325.0f);
            draugr.m_20049_("wave_mob");
            this.currentWaveMobs.add((Mob)draugr);
            world.m_7967_((Entity)draugr);
        }
    }

    private void summonBoss(ServerLevel world, BlockPos pos) {
        EntityPossessedVikingArmor boss = new EntityPossessedVikingArmor((EntityType<? extends Monster>)((EntityType)EntityRegistry.POSSESSED_VIKING_ARMOR.get()), (Level)world);
        boss.m_7678_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_(), 0.0f, 0.0f);
        boss.m_20049_("wave_mob");
        this.currentWaveMobs.add((Mob)boss);
        world.m_7967_((Entity)boss);
    }

    private Vec3 getRandomPositionAround(BlockPos pos, Random random) {
        double offsetX = (random.nextDouble() * 2.0 - 1.0) * 2.0;
        double offsetY = 1.0;
        double offsetZ = (random.nextDouble() * 2.0 - 1.0) * 2.0;
        return new Vec3((double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ);
    }

    public void incrementWave() {
        ++this.wave;
        if (this.wave <= 4) {
            this.summonWave((ServerLevel)this.f_58857_, this.f_58858_, new Random());
        }
    }

    public void onMobDeath(Mob mob) {
        this.currentWaveMobs.remove(mob);
        if (this.currentWaveMobs.isEmpty()) {
            this.incrementWave();
        }
        if (this.currentWaveMobs.isEmpty() && this.wave == 4) {
            this.wave = 1;
        }
    }
}

