/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;

public class BlockMod
extends Block {
    private final int flammability;
    private final int fireSpread;
    private final boolean selfDrop;
    private final Item customDrop;

    public BlockMod(BlockBehaviour.Properties properties) {
        this(properties, false, null);
    }

    public BlockMod(BlockBehaviour.Properties properties, boolean selfDrop) {
        this(properties, selfDrop, null);
    }

    public BlockMod(BlockBehaviour.Properties properties, Item customDrop) {
        super(properties);
        this.flammability = 0;
        this.fireSpread = 0;
        this.selfDrop = false;
        this.customDrop = customDrop;
    }

    public BlockMod(BlockBehaviour.Properties properties, boolean selfDrop, Item customDrop) {
        super(properties);
        this.flammability = 0;
        this.fireSpread = 0;
        this.selfDrop = selfDrop;
        this.customDrop = customDrop;
    }

    public BlockMod(MapColor color, float hardness, float resistance) {
        this(color, hardness, resistance, false, null);
    }

    public BlockMod(MapColor color, float hardness, float resistance, boolean selfDrop) {
        this(color, hardness, resistance, selfDrop, null);
    }

    public BlockMod(MapColor color, float hardness, float resistance, boolean selfDrop, Item customDrop) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60999_().m_60913_(hardness, resistance).m_280658_(NoteBlockInstrument.BASEDRUM));
        this.flammability = 0;
        this.fireSpread = 0;
        this.selfDrop = selfDrop;
        this.customDrop = customDrop;
    }

    public BlockMod(MapColor color, float hardness, float resistance, SoundType sound, NoteBlockInstrument instrument) {
        this(color, hardness, resistance, sound, instrument, false, null);
    }

    public BlockMod(MapColor color, float hardness, float resistance, SoundType sound, NoteBlockInstrument instrument, boolean selfDrop) {
        this(color, hardness, resistance, sound, instrument, selfDrop, null);
    }

    public BlockMod(MapColor color, float hardness, float resistance, SoundType sound, NoteBlockInstrument instrument, boolean selfDrop, Item customDrop) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60999_().m_60913_(hardness, resistance).m_60918_(sound).m_280658_(instrument));
        this.flammability = 0;
        this.fireSpread = 0;
        this.selfDrop = selfDrop;
        this.customDrop = customDrop;
    }

    public BlockMod(MapColor color, float hardness, float resistance, int flammability, int fireSpread, SoundType sound, NoteBlockInstrument instrument) {
        this(color, hardness, resistance, flammability, fireSpread, sound, instrument, false, null);
    }

    public BlockMod(MapColor color, float hardness, float resistance, int flammability, int fireSpread, SoundType sound, NoteBlockInstrument instrument, boolean selfDrop) {
        this(color, hardness, resistance, flammability, fireSpread, sound, instrument, selfDrop, null);
    }

    public BlockMod(MapColor color, float hardness, float resistance, int flammability, int fireSpread, SoundType sound, NoteBlockInstrument instrument, boolean selfDrop, Item customDrop) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60913_(hardness, resistance).m_60918_(sound).m_280658_(instrument));
        this.flammability = flammability;
        this.fireSpread = fireSpread;
        this.selfDrop = selfDrop;
        this.customDrop = customDrop;
    }

    public BlockMod(MapColor color, int luminance) {
        this(color, luminance, true, null);
    }

    public BlockMod(MapColor color, int luminance, boolean selfDrop) {
        this(color, luminance, selfDrop, null);
    }

    public BlockMod(MapColor color, int luminance, boolean selfDrop, Item customDrop) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60999_().m_60913_(50.0f, 1200.0f).m_278166_(PushReaction.BLOCK).m_280658_(NoteBlockInstrument.BASEDRUM).m_60953_(state -> luminance));
        this.flammability = 0;
        this.fireSpread = 0;
        this.selfDrop = selfDrop;
        this.customDrop = customDrop;
    }

    public int getFlammability(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return this.fireSpread;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (this.customDrop != null) {
            return Collections.singletonList(new ItemStack((ItemLike)this.customDrop));
        }
        if (this.selfDrop) {
            List drops = super.m_49635_(state, builder);
            if (!drops.isEmpty()) {
                return drops;
            }
            return Collections.singletonList(new ItemStack((ItemLike)this));
        }
        return super.m_49635_(state, builder);
    }
}

