/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockModCrop
extends CropBlock {
    boolean boneMeal;
    int age;
    int maxAge;
    ResourceLocation seed;
    protected List<VoxelShape> growthStageHitboxes = new ArrayList<VoxelShape>();
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public BlockModCrop() {
        this(0.8);
    }

    public BlockModCrop(double maxHeight) {
        this(maxHeight, 0);
    }

    public BlockModCrop(double maxHeight, int maxAge) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY).m_60910_().m_60955_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_));
        this.maxAge = maxAge;
        double step = maxHeight / ((double)this.m_7419_() + 1.0);
        for (int i = 0; i <= this.m_7419_(); ++i) {
            this.growthStageHitboxes.add(Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, step * (double)(i + 1), 1.0)));
        }
    }

    public BlockModCrop(int age, ResourceLocation seed) {
        this(0.8, age);
        this.age = age;
        this.seed = seed;
    }

    public BlockModCrop(int age, ResourceLocation seed, Boolean disableBoneMeal) {
        this(0.8, age);
        this.age = age;
        this.seed = seed;
        this.boneMeal = disableBoneMeal;
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return !this.boneMeal;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE_BY_AGE[(Integer)p_220053_1_.m_61143_((Property)this.m_7959_())];
    }

    public int m_7419_() {
        return this.age;
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        return (levelReader.m_45524_(pos, 0) >= 8 || levelReader.m_45527_(pos)) && levelReader.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50093_);
    }

    protected ItemLike m_6404_() {
        return (ItemLike)ForgeRegistries.ITEMS.getValue(this.seed);
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.seed));
    }
}

