/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.block_entities.furnace.ModFurnaceBlockEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class BlockModFurnace
extends FurnaceBlock {
    public final Supplier<BlockEntityType<? extends ModFurnaceBlockEntity>> blockEntityType;
    private final boolean selfDrop;

    public BlockModFurnace(Supplier<BlockEntityType<? extends ModFurnaceBlockEntity>> blockEntity, MapColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60999_().m_60978_(3.5f).m_280658_(NoteBlockInstrument.BASEDRUM));
        this.blockEntityType = blockEntity;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_48683_, (Comparable)Direction.NORTH)).m_61124_((Property)f_48684_, (Comparable)Boolean.valueOf(false)));
        this.selfDrop = false;
    }

    public BlockModFurnace(Supplier<BlockEntityType<? extends ModFurnaceBlockEntity>> blockEntity, MapColor color, boolean selfDrop) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60999_().m_60978_(3.5f).m_280658_(NoteBlockInstrument.BASEDRUM));
        this.blockEntityType = blockEntity;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_48683_, (Comparable)Direction.NORTH)).m_61124_((Property)f_48684_, (Comparable)Boolean.valueOf(false)));
        this.selfDrop = selfDrop;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)AbstractFurnaceBlock.f_48684_) != false ? 12 : 0;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity blockentity;
        if (stack.m_41788_() && (blockentity = level.m_7702_(pos)) instanceof ModFurnaceBlockEntity) {
            ((ModFurnaceBlockEntity)blockentity).m_58638_(stack.m_41786_());
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState st, boolean b) {
        if (!state.m_60713_(st.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof ModFurnaceBlockEntity) {
                if (level instanceof ServerLevel) {
                    Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((ModFurnaceBlockEntity)blockentity));
                    ((ModFurnaceBlockEntity)blockentity).getRecipesToAwardAndPopExperience((ServerLevel)level, Vec3.m_82512_((Vec3i)pos));
                }
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, st, b);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockModFurnace.createFurnaceTicker(type, level, this.blockEntityType.get());
    }

    @Nullable
    private static <T extends BlockEntity> BlockEntityTicker<T> createFurnaceTicker(BlockEntityType<T> p_151989_, Level p_151988_, BlockEntityType<? extends ModFurnaceBlockEntity> p_151990_) {
        return p_151988_.f_46443_ ? null : BlockModFurnace.m_152132_(p_151989_, p_151990_, ModFurnaceBlockEntity::serverTick);
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return (BlockEntity)Objects.requireNonNull((ModFurnaceBlockEntity)this.blockEntityType.get().m_155264_(pos, state));
    }

    protected void m_7137_(Level level, BlockPos pos, Player player) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof ModFurnaceBlockEntity) {
            player.m_5893_((MenuProvider)blockentity);
            player.m_36220_(Stats.f_12966_);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (!this.selfDrop) {
            return super.m_49635_(state, builder);
        }
        List drops = super.m_49635_(state, builder);
        if (!drops.isEmpty()) {
            return drops;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this));
    }
}

