/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.blocks.base.BlockMod;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockModGrass
extends BlockMod
implements BonemealableBlock {
    protected final Supplier<Block> dirtSupplier;

    public BlockModGrass(Supplier<Block> dirt, MapColor colour) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(colour).m_60977_().m_60978_(0.6f).m_60918_(SoundType.f_56740_));
        this.dirtSupplier = dirt;
    }

    public BlockModGrass(Supplier<Block> dirt) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283772_).m_60977_().m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56710_).m_280658_(NoteBlockInstrument.BASEDRUM));
        this.dirtSupplier = dirt;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        Block block = plantable.getPlant(world, pos.m_7494_()).m_60734_();
        return block instanceof BushBlock && !(block instanceof WaterlilyBlock) && !(block instanceof CropBlock);
    }

    public BlockState grass() {
        if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "eden_grass"))) {
            return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "eden_brush"))).m_49966_();
        }
        if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "wildwood_grass"))) {
            return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "moonlight_fern"))).m_49966_();
        }
        if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "apalachia_grass"))) {
            return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "apalachia_tallgrass"))).m_49966_();
        }
        if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "skythern_grass"))) {
            return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "skythern_brush"))).m_49966_();
        }
        if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_grass"))) {
            return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_brush"))).m_49966_();
        }
        return null;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean b) {
        return level.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState myState = this.m_49966_();
        this.place(level, random, pos.m_7494_(), myState);
        this.place(level, random, pos.m_7495_(), myState);
        this.place(level, random, pos.m_122012_(), myState);
        this.place(level, random, pos.m_122029_(), myState);
        this.place(level, random, pos.m_122019_(), myState);
        this.place(level, random, pos.m_122024_(), myState);
    }

    public void place(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (random.m_188499_()) {
            pos = pos.m_121945_(Direction.m_235672_((RandomSource)random));
        }
        BlockPos above = pos.m_7494_();
        if (BlockModGrass.canPropagate(state, (LevelReader)level, pos)) {
            BlockState grass;
            if (level.m_8055_(pos).m_60713_(this.dirtSupplier.get())) {
                level.m_7731_(pos, state, 3);
            } else if (level.m_8055_(pos).m_60713_((Block)this) && (grass = this.grass()) != null) {
                level.m_7731_(above, grass, 3);
            }
        }
    }

    private static boolean canBeGrass(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50125_) || blockstate.m_60713_(Blocks.f_50127_) || blockstate.m_60713_(Blocks.f_152499_)) {
            return true;
        }
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LightEngine.m_284282_((BlockGetter)level, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)level, blockpos));
        return i < level.m_7469_();
    }

    private static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        return BlockModGrass.canBeGrass(state, level, pos) && !level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!BlockModGrass.canBeGrass(state, (LevelReader)level, pos)) {
            level.m_46597_(pos, this.dirtSupplier.get().m_49966_());
        } else if (level.m_46803_(pos.m_7494_()) >= 9) {
            BlockState blockstate = this.m_49966_();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                if (level.m_8055_(blockpos).m_60713_(this.dirtSupplier.get()) && !BlockModGrass.canPropagate(blockstate, (LevelReader)level, blockpos)) continue;
            }
        }
    }
}

