/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.PointOfInterestRegistry;
import divinerpg.util.teleport.DivineTeleporter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BlockModPortal
extends BlockMod {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static Block frame;

    public BlockModPortal(Block frame) {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(-1.0f, 1000.0f).m_60910_().m_60953_(state -> 11).m_60918_(SoundType.f_56744_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> X_AXIS_AABB;
            case Direction.Axis.Z -> Z_AXIS_AABB;
            case Direction.Axis.Y -> throw new IllegalStateException("Y axis is not valid for this block");
        };
    }

    @NotNull
    public BlockState m_7417_(BlockState stateIn, Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction.Axis direction$axis = facing.m_122434_();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.m_61143_(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.m_122479_();
        return !flag && facingState.m_60734_() != this && !new Size(worldIn, currentPos, direction$axis1, this, frame).validatePortal() ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, Entity entity) {
        if (entity.m_20159_() || entity.m_20160_() || !entity.m_6072_() || entity.m_9236_().f_46443_) {
            return;
        }
        if (entity.m_20092_()) {
            entity.m_20091_();
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        MinecraftServer server = world.m_7654_();
        if (server == null) {
            return;
        }
        entity.m_9236_().m_46473_().m_6180_(world.m_46472_().m_135782_().m_135815_());
        PortalConfig portalConfig = PortalConfig.getPortalConfigForBlock(this, (ResourceKey<Level>)world.m_46472_());
        if (portalConfig == null) {
            entity.m_9236_().m_46473_().m_7238_();
            return;
        }
        ResourceKey<Level> targetDim = portalConfig.target;
        ServerLevel targetWorld = server.m_129880_(targetDim);
        if (targetWorld == null) {
            entity.m_9236_().m_46473_().m_7238_();
            return;
        }
        entity.changeDimension(targetWorld, (ITeleporter)new DivineTeleporter(targetWorld, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", portalConfig.portalBlockName)), portalConfig.portalBaseBlock, true, portalConfig.poiKey));
        entity.m_9236_().m_46473_().m_7238_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@NotNull BlockState state, Level world, BlockPos pos, @NotNull RandomSource rand) {
        boolean horizontal;
        boolean bl = horizontal = !world.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !world.m_8055_(pos.m_122029_()).m_60713_((Block)this);
        Object particle = this == BlockRegistry.edenPortal.get() ? (ParticleOptions)ParticleRegistry.EDEN_PORTAL.get() : (this == BlockRegistry.wildwoodPortal.get() ? (ParticleOptions)ParticleRegistry.WILDWOOD_PORTAL.get() : (this == BlockRegistry.apalachiaPortal.get() ? (ParticleOptions)ParticleRegistry.APALACHIA_PORTAL.get() : (this == BlockRegistry.skythernPortal.get() ? (ParticleOptions)ParticleRegistry.SKYTHERN_PORTAL.get() : (this == BlockRegistry.mortumPortal.get() ? (ParticleOptions)ParticleRegistry.MORTUM_PORTAL.get() : (this == BlockRegistry.iceikaPortal.get() ? (ParticleOptions)ParticleRegistry.FROST.get() : (this == BlockRegistry.euca_portal.get() ? (ParticleOptions)ParticleRegistry.EDEN_PORTAL.get() : ParticleTypes.f_123760_))))));
        for (int i = 0; i < 4; ++i) {
            int dir;
            double x = (double)pos.m_123341_() + rand.m_188500_();
            double y = (double)pos.m_123342_() + rand.m_188500_();
            double z = (double)pos.m_123343_() + rand.m_188500_();
            double xSpeed = ((double)rand.m_188501_() - 0.5) * 0.5;
            double ySpeed = ((double)rand.m_188501_() - 0.5) * 0.5;
            double zSpeed = ((double)rand.m_188501_() - 0.5) * 0.5;
            int n = dir = rand.m_188499_() ? 1 : -1;
            if (horizontal) {
                x = (double)pos.m_123341_() + 0.5 + 0.25 * (double)dir;
                xSpeed = rand.m_188501_() * 2.0f * (float)dir;
            } else {
                z = (double)pos.m_123343_() + 0.5 + 0.25 * (double)dir;
                zSpeed = rand.m_188501_() * 2.0f * (float)dir;
            }
            world.m_7106_(particle, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Direction.Axis.Z -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    case Direction.Axis.X -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    default -> state;
                };
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public boolean makePortal(LevelAccessor worldIn, BlockPos pos) {
        Size portal = this.isPortal(worldIn, pos);
        if (worldIn.m_8055_(pos.m_7495_()) == Blocks.f_50752_.m_49966_()) {
            pos = pos.m_6625_(10);
        }
        if (portal != null && !BlockModPortal.onTrySpawnPortal(worldIn, pos, portal)) {
            portal.createPortalBlocks();
            return true;
        }
        return false;
    }

    public static boolean onTrySpawnPortal(LevelAccessor world, BlockPos pos, Size size) {
        return MinecraftForge.EVENT_BUS.post((Event)new PortalSpawnEvent(world, pos, world.m_8055_(pos), size));
    }

    @Nullable
    public Size isPortal(LevelAccessor worldIn, BlockPos pos) {
        Size portalX = new Size(worldIn, pos, Direction.Axis.X, this, worldIn.m_8055_(pos.m_7495_()).m_60734_());
        if (portalX.isValid() && portalX.portalBlockCount == 0) {
            return portalX;
        }
        Size portalZ = new Size(worldIn, pos, Direction.Axis.Z, this, worldIn.m_8055_(pos.m_7495_()).m_60734_());
        return portalZ.isValid() && portalZ.portalBlockCount == 0 ? portalZ : null;
    }

    public static class Size {
        private final LevelAccessor world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private final Block portal;
        private final Block frame;

        public Size(LevelAccessor worldIn, BlockPos pos, Direction.Axis axisIn, Block portal, Block frame) {
            this.world = worldIn;
            this.axis = axisIn;
            this.portal = portal;
            this.frame = frame;
            if (axisIn == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.m_5484_(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.canConnect(this.world.m_8055_(blockpos = pos.m_5484_(directionIn, i))) && this.world.m_8055_(blockpos.m_7495_()).m_60734_().equals(this.world.m_8055_(pos.m_7495_()).m_60734_()); ++i) {
            }
            BlockPos framePos = pos.m_5484_(directionIn, i);
            return this.world.m_8055_(framePos).m_60734_().equals(this.world.m_8055_(pos.m_7495_()).m_60734_()) ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos framePos;
                    BlockPos blockpos = this.bottomLeft.m_5484_(this.rightDir, i).m_6630_(this.height);
                    BlockState blockstate = this.world.m_8055_(blockpos);
                    if (!this.canConnect(blockstate)) break block0;
                    Block block = blockstate.m_60734_();
                    if (block == this.portal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.world.m_8055_(framePos = blockpos.m_121945_(this.leftDir)).m_60734_().equals(this.frame) || this.world.m_8055_(framePos).m_60734_() != this.frame : i == this.width - 1 && (!this.world.m_8055_(framePos = blockpos.m_121945_(this.rightDir)).m_60734_().equals(this.frame) || this.world.m_8055_(framePos).m_60734_() != this.frame)) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.m_5484_(this.rightDir, j).m_6630_(this.height);
                if (!this.world.m_8055_(framePos).m_60734_().equals(this.frame)) {
                    this.height = 0;
                    break;
                }
                if (this.world.m_8055_(framePos).m_60734_() == this.frame) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean canConnect(BlockState pos) {
            Block block = pos.m_60734_();
            return pos.m_60795_() || block == this.portal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void createPortalBlocks() {
            BlockState blockstate = (BlockState)this.portal.m_49966_().m_61124_(AXIS, (Comparable)this.axis);
            if (this.bottomLeft != null) {
                BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(pos -> this.world.m_7731_(pos, blockstate, 18));
            }
        }

        private boolean isPortalCountValidForSize() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean validatePortal() {
            return this.isValid() && this.isPortalCountValidForSize();
        }
    }

    public record PortalConfig(Block portalBlock, ResourceKey<Level> target, String portalBlockName, Block portalBaseBlock, ResourceKey<PoiType> poiKey) {
        private static PortalConfig getPortalConfigForBlock(Block block, ResourceKey<Level> currentDim) {
            if (block == BlockRegistry.edenPortal.get()) {
                return new PortalConfig(block, currentDim == LevelRegistry.EDEN ? Level.f_46428_ : LevelRegistry.EDEN, "eden_portal", (Block)BlockRegistry.divineRock.get(), (ResourceKey<PoiType>)PointOfInterestRegistry.EDEN_PORTAL.getKey());
            }
            if (block == BlockRegistry.wildwoodPortal.get()) {
                return new PortalConfig(block, currentDim == LevelRegistry.WILDWOOD ? Level.f_46428_ : LevelRegistry.WILDWOOD, "wildwood_portal", (Block)BlockRegistry.edenBlock.get(), (ResourceKey<PoiType>)PointOfInterestRegistry.WILDWOOD_PORTAL.getKey());
            }
            if (block == BlockRegistry.apalachiaPortal.get()) {
                return new PortalConfig(block, currentDim == LevelRegistry.APALACHIA ? Level.f_46428_ : LevelRegistry.APALACHIA, "apalachia_portal", (Block)BlockRegistry.wildwoodBlock.get(), (ResourceKey<PoiType>)PointOfInterestRegistry.APALACHIA_PORTAL.getKey());
            }
            if (block == BlockRegistry.skythernPortal.get()) {
                return new PortalConfig(block, currentDim == LevelRegistry.SKYTHERN ? Level.f_46428_ : LevelRegistry.SKYTHERN, "skythern_portal", (Block)BlockRegistry.apalachiaBlock.get(), (ResourceKey<PoiType>)PointOfInterestRegistry.SKYTHERN_PORTAL.getKey());
            }
            if (block == BlockRegistry.mortumPortal.get()) {
                return new PortalConfig(block, currentDim == LevelRegistry.MORTUM ? Level.f_46428_ : LevelRegistry.MORTUM, "mortum_portal", (Block)BlockRegistry.skythernBlock.get(), (ResourceKey<PoiType>)PointOfInterestRegistry.MORTUM_PORTAL.getKey());
            }
            if (block == BlockRegistry.iceikaPortal.get()) {
                return new PortalConfig(block, currentDim == LevelRegistry.ICEIKA ? Level.f_46428_ : LevelRegistry.ICEIKA, "iceika_portal", (Block)BlockRegistry.iceika_portal_frame.get(), (ResourceKey<PoiType>)PointOfInterestRegistry.ICEIKA_PORTAL.getKey());
            }
            if (block == BlockRegistry.euca_portal.get()) {
                return new PortalConfig(block, currentDim == LevelRegistry.EUCA ? Level.f_46428_ : LevelRegistry.EUCA, "euca_portal", (Block)BlockRegistry.euca_portal_frame.get(), (ResourceKey<PoiType>)PointOfInterestRegistry.EUCA_PORTAL.getKey());
            }
            return null;
        }
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        public PortalSpawnEvent(LevelAccessor world, BlockPos pos, BlockState state, Size size) {
            super(world, pos, state);
        }
    }
}

