/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import com.idark.valoria.registries.level.LevelGen;
import divinerpg.block_entities.block.PrivateCoreBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="divinerpg", value={Dist.DEDICATED_SERVER})
public class BlockModPrivateCore
extends BaseEntityBlock {
    public static final IntegerProperty RADIUS = IntegerProperty.m_61631_((String)"radius", (int)0, (int)8);

    public BlockModPrivateCore() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(-1.0f));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{RADIUS});
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.PRIVATE_CORE.get()).m_155264_(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        if (((Level)event.getLevel()).m_46472_() == LevelGen.VALORIA_KEY && BlockModPrivateCore.isNearBlockEntity(player, pos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity;
        if (((Level)event.getLevel()).m_46472_() == LevelGen.VALORIA_KEY && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (!event.getState().m_60713_((Block)BlockRegistry.privateCore.get()) && BlockModPrivateCore.isNearBlockEntity(player, event.getPos())) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean isNearBlockEntity(Player player, BlockPos pos) {
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-8, -8, -8), (BlockPos)pos.m_7918_(8, 8, 8))) {
            BlockEntity blockEntity = player.m_9236_().m_7702_(checkPos);
            if (!(blockEntity instanceof PrivateCoreBlockEntity)) continue;
            BlockState blockState = blockEntity.m_58900_();
            BlockPos corePos = blockEntity.m_58899_();
            int r = (Integer)blockState.m_61143_((Property)RADIUS);
            return r != 0 && pos.m_123331_((Vec3i)corePos) <= (double)(r * r);
        }
        return false;
    }
}

