/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capability;

import divinerpg.packet.DivineRPGPacketHandler;
import divinerpg.packet.PacketArcanaBar;
import divinerpg.registries.AttributesRegistry;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.PacketDistributor;

public class Arcana
implements INBTSerializable<CompoundTag> {
    public static float clientMax;
    public static float clientAmount;
    private int tickDelay = 4;
    private float arcana;

    public float getMaxArcana(@Nullable LivingEntity entity, boolean clientSide) {
        if (clientSide) {
            return clientMax;
        }
        if (entity != null && entity.m_21051_((Attribute)AttributesRegistry.ARCANA_MAX.get()) != null) {
            return (float)entity.m_21133_((Attribute)AttributesRegistry.ARCANA_MAX.get());
        }
        return 200.0f;
    }

    public float getAmount(boolean clientSide) {
        if (clientSide) {
            return clientAmount;
        }
        return this.arcana;
    }

    public float getArcana() {
        return this.arcana;
    }

    private void sendDataToClient(@Nullable LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            DivineRPGPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketArcanaBar(this, (LivingEntity)player));
        }
    }

    public void setAmount(@Nullable LivingEntity entity, float amount) {
        float previous = this.arcana;
        float maxArcana = this.getMaxArcana(entity, false);
        this.arcana = amount > maxArcana ? maxArcana : Math.max(amount, 0.0f);
        if (previous != this.arcana) {
            this.sendDataToClient(entity);
        }
    }

    public void modifyAmount(@Nullable LivingEntity entity, float amount) {
        Player player;
        if (!(amount == 0.0f || !(amount > 0.0f) && entity instanceof Player && (player = (Player)entity).m_7500_())) {
            this.setAmount(entity, this.arcana + amount);
        }
    }

    public void consume(Player player, float points) {
        this.modifyAmount((LivingEntity)player, -points);
    }

    public void regen(@Nullable LivingEntity entity) {
        if ((entity != null ? entity.m_9236_().m_46467_() : 0L) % (long)this.tickDelay == 0L) {
            this.modifyAmount(entity, (float)entity.m_21133_((Attribute)AttributesRegistry.ARCANA_REGEN.get()));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("arcana", this.arcana);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.arcana = tag.m_128457_("arcana");
    }
}

