/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import pro.komaru.tridot.common.config.ClientConfig;

public class DivineDashOverlayRender {
    public static int dashTime = 0;
    public static boolean isDash = false;
    private static final ResourceLocation DASH = new ResourceLocation("valoria:textures/gui/overlay/speedlines.png");

    private DivineDashOverlayRender() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showDashOverlay() {
        if (((Boolean)ClientConfig.ABILITY_OVERLAY.get()).booleanValue()) {
            isDash = true;
        }
    }

    public static void tick(TickEvent.ClientTickEvent event) {
        if (isDash) {
            if (dashTime < 35) {
                ++dashTime;
            } else {
                dashTime = 0;
                isDash = false;
            }
        }
    }

    public static void onDrawScreenPost(RenderGuiOverlayEvent.Post event) {
        if (dashTime > 0) {
            Minecraft mc = Minecraft.m_91087_();
            GuiGraphics gui = event.getGuiGraphics();
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_252880_(0.0f, 0.0f, -200.0f);
            float ticks = (float)dashTime + event.getPartialTick();
            float alpha = 0.5f;
            if (ticks < 10.0f) {
                alpha = 5.0f / ticks;
            }
            if (ticks >= 20.0f) {
                alpha = 0.5f - (ticks - 20.0f) / 15.0f;
            }
            int width = mc.m_91268_().m_85445_();
            int height = mc.m_91268_().m_85446_();
            float f = 0.1f;
            RenderSystem.applyModelViewMatrix();
            Lighting.m_84931_();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            gui.m_280246_(f * alpha, f * alpha, f * alpha, 1.0f);
            gui.m_280163_(DASH, 0, 0, 0.0f, 0.0f, 1920, 1080, width, height);
            gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.applyModelViewMatrix();
            gui.m_280168_().m_85849_();
        }
    }
}

