/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityLadyLuna;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class ModelLadyLuna<T extends Mob>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("lady_luna");
    private final ModelPart Body;
    private final ModelPart head;
    private final ModelPart Right_arm;
    private final ModelPart Left_arm;
    private final ModelPart Right_leg;
    private final ModelPart Left_leg;
    private final ModelPart antena_r1;
    private final ModelPart antena_r2;
    private final ModelPart left_wing_1;
    private final ModelPart left_wing_2;
    private final ModelPart left_wing_3;
    private final ModelPart right_wing_1;
    private final ModelPart right_wing_2;
    private final ModelPart right_wing_3;

    public ModelLadyLuna(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Body = root.m_171324_("Body");
        this.head = root.m_171324_("head");
        this.Right_arm = root.m_171324_("Right_arm");
        this.Left_arm = root.m_171324_("Left_arm");
        this.Right_leg = root.m_171324_("Right_leg");
        this.Left_leg = root.m_171324_("Left_leg");
        this.antena_r1 = this.head.m_171324_("antena_r1");
        this.antena_r2 = this.head.m_171324_("antena_r2");
        this.left_wing_1 = this.Body.m_171324_("left_wing_1_r1");
        this.left_wing_2 = this.Body.m_171324_("left_wing_2_r1");
        this.left_wing_3 = this.Body.m_171324_("left_wing_3_r1");
        this.right_wing_1 = this.Body.m_171324_("right_wing_1_r1");
        this.right_wing_2 = this.Body.m_171324_("right_wing_2_r1");
        this.right_wing_3 = this.Body.m_171324_("right_wing_3_r1");
    }

    public static void addHead(MeshDefinition pMesh) {
        PartDefinition partdefinition = pMesh.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(24, 30).m_171488_(-4.0f, -11.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        head.m_171599_("antena_r1", CubeListBuilder.m_171558_().m_171514_(48, 17).m_171488_(1.7382f, -10.6322f, -16.559f, 0.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.8727f, (float)0.6545f, (float)-0.2618f));
        head.m_171599_("antena_r2", CubeListBuilder.m_171558_().m_171514_(48, 22).m_171488_(-1.7382f, -10.6322f, -16.559f, 0.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.8727f, (float)-0.6545f, (float)0.2618f));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        ModelLadyLuna.addHead(meshdefinition);
        PartDefinition Right_arm = partdefinition.m_171599_("Right_arm", CubeListBuilder.m_171558_().m_171514_(12, 38).m_171488_(0.0f, -1.0f, -1.0f, 3.0f, 27.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-15.0f, (float)-0.5f));
        PartDefinition Left_arm = partdefinition.m_171599_("Left_arm", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-3.0f, -1.0f, -1.0f, 3.0f, 27.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-15.0f, (float)-0.5f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(32, 10).m_171488_(-5.0f, -10.0f, -1.0f, 10.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-6.0f, -20.0f, -1.0f, 12.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-2.0f));
        PartDefinition left_wing_3_r1 = Body.m_171599_("left_wing_3_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 11.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-17.0f, (float)5.0f, (float)0.4538f, (float)-0.5934f, (float)-0.2443f));
        PartDefinition left_wing_2_r1 = Body.m_171599_("left_wing_2_r1", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171480_().m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 11.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-14.0f, (float)5.0f, (float)-0.1047f, (float)-0.9076f, (float)-0.1571f));
        PartDefinition left_wing_1_r1 = Body.m_171599_("left_wing_1_r1", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171480_().m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 11.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-11.0f, (float)5.0f, (float)-1.0297f, (float)-0.8203f, (float)0.3491f));
        PartDefinition right_wing_3_r1 = Body.m_171599_("right_wing_3_r1", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 11.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-11.0f, (float)5.0f, (float)-1.0297f, (float)0.8203f, (float)-0.3491f));
        PartDefinition right_wing_2_r1 = Body.m_171599_("right_wing_2_r1", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 11.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-14.0f, (float)5.0f, (float)-0.1047f, (float)0.9076f, (float)0.1571f));
        PartDefinition right_wing_1_r1 = Body.m_171599_("right_wing_1_r1", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 11.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-17.0f, (float)5.0f, (float)0.4538f, (float)0.5934f, (float)0.2443f));
        PartDefinition Right_leg = partdefinition.m_171599_("Right_leg", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-2.0f, 0.0f, -1.0f, 4.0f, 20.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)4.0f, (float)-1.0f));
        PartDefinition Left_leg = partdefinition.m_171599_("Left_leg", CubeListBuilder.m_171558_().m_171514_(24, 46).m_171488_(-2.0f, 0.0f, -1.0f, 4.0f, 20.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)4.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f2 = 0.060000002f;
        float f1 = ageInTicks * 0.1f * 0.5f;
        this.antena_r1.f_104205_ = -0.31415927f - Mth.m_14089_((float)(f1 * 1.25f)) * f2;
        this.antena_r2.f_104205_ = 0.28559935f + Mth.m_14089_((float)f1) * f2;
        this.Left_leg.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * ((double)limbSwingAmount * 0.75));
        this.Right_leg.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * ((double)limbSwingAmount * 0.75));
        this.Left_arm.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * ((double)limbSwingAmount * 0.75) * 0.5);
        this.Right_arm.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * ((double)limbSwingAmount * 0.75) * 0.5);
        this.Left_arm.f_104204_ = 0.0f;
        this.Right_arm.f_104204_ = 0.0f;
        this.Left_arm.f_104205_ = 0.0f;
        this.Right_arm.f_104205_ = 0.0f;
        this.left_wing_1.f_104205_ = -0.5235988f - Mth.m_14089_((float)(f1 * 1.2f)) * f2;
        this.left_wing_2.f_104205_ = -0.5235988f - Mth.m_14089_((float)(f1 * 1.2f)) * f2;
        this.left_wing_3.f_104205_ = -0.3926991f - Mth.m_14089_((float)(f1 * 1.2f)) * f2;
        this.right_wing_1.f_104205_ = 0.5235988f + Mth.m_14089_((float)f1) * f2;
        this.right_wing_2.f_104205_ = 0.5235988f + Mth.m_14089_((float)f1) * f2;
        this.right_wing_3.f_104205_ = 0.5235988f + Mth.m_14089_((float)f1) * f2;
        if (entity instanceof EntityLadyLuna) {
            EntityLadyLuna luna = (EntityLadyLuna)((Object)entity);
            if (luna.isJumping()) {
                this.left_wing_1.f_233554_ = 2.5f;
                this.left_wing_1.f_233553_ = 2.5f;
                this.left_wing_2.f_233554_ = 2.5f;
                this.left_wing_2.f_233553_ = 2.5f;
                this.left_wing_3.f_233554_ = 2.5f;
                this.left_wing_3.f_233553_ = 2.5f;
                this.right_wing_1.f_233554_ = 2.5f;
                this.right_wing_1.f_233553_ = 2.5f;
                this.right_wing_2.f_233554_ = 2.5f;
                this.right_wing_2.f_233553_ = 2.5f;
                this.right_wing_3.f_233554_ = 2.5f;
                this.right_wing_3.f_233553_ = 2.5f;
            } else {
                this.left_wing_1.f_233554_ = 1.0f;
                this.left_wing_1.f_233553_ = 1.0f;
                this.left_wing_2.f_233554_ = 1.0f;
                this.left_wing_2.f_233553_ = 1.0f;
                this.left_wing_3.f_233554_ = 1.0f;
                this.left_wing_3.f_233553_ = 1.0f;
                this.right_wing_1.f_233554_ = 1.0f;
                this.right_wing_1.f_233553_ = 1.0f;
                this.right_wing_2.f_233554_ = 1.0f;
                this.right_wing_2.f_233553_ = 1.0f;
                this.right_wing_3.f_233554_ = 1.0f;
                this.right_wing_3.f_233553_ = 1.0f;
            }
        }
        this.setupAttackAnimation(entity);
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
    }

    protected ModelPart getArm(HumanoidArm humanoidarm) {
        return this.Right_arm;
    }

    private HumanoidArm getAttackArm(T ent) {
        return ent.m_5737_();
    }

    protected void setupAttackAnimation(T ent) {
        if (!(this.f_102608_ <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(ent);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.f_102608_;
            this.Body.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            this.Right_arm.f_104204_ += this.Body.f_104204_;
            f = 1.0f - this.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * 0.525f;
            modelpart.f_104203_ -= f1 * 0.6f + f2;
            modelpart.f_104204_ += this.Body.f_104204_ * 0.6f;
        }
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Left_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Right_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

