/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityRaglok;
import divinerpg.util.ClientUtils;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ModelRaglok<T extends EntityRaglok>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("raglok");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_wing;
    private final ModelPart left_wing;
    private final ModelPart portal;
    private final ModelPart root;
    public static final AnimationDefinition SUMMON = AnimationDefinition.Builder.m_232275_((float)2.6f).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.2916767f, KeyframeAnimations.m_253186_((float)-15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5834334f, KeyframeAnimations.m_253186_((float)-25.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0416766f, KeyframeAnimations.m_253186_((float)-15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.5416766f, KeyframeAnimations.m_253186_((float)-25.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.0f, KeyframeAnimations.m_253186_((float)-15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.375f, KeyframeAnimations.m_253186_((float)-25.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.5416765f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("body", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.2916767f, KeyframeAnimations.m_253186_((float)0.0f, (float)5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5834334f, KeyframeAnimations.m_253186_((float)0.0f, (float)-5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.7916766f, KeyframeAnimations.m_253186_((float)0.0f, (float)5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)-5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.2083433f, KeyframeAnimations.m_253186_((float)0.0f, (float)5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.4167666f, KeyframeAnimations.m_253186_((float)0.0f, (float)-5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.6766667f, KeyframeAnimations.m_253186_((float)0.0f, (float)5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.875f, KeyframeAnimations.m_253186_((float)0.0f, (float)-5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.0834334f, KeyframeAnimations.m_253186_((float)0.0f, (float)5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.2916765f, KeyframeAnimations.m_253186_((float)0.0f, (float)-5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.5416765f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("right_arm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.375f, KeyframeAnimations.m_253186_((float)-162.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5834334f, KeyframeAnimations.m_253186_((float)-180.0f, (float)-6.0f, (float)15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.7916766f, KeyframeAnimations.m_253186_((float)-162.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-180.0f, (float)-6.0f, (float)15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.2083433f, KeyframeAnimations.m_253186_((float)-180.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.4167666f, KeyframeAnimations.m_253186_((float)-180.0f, (float)-6.0f, (float)15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.6766667f, KeyframeAnimations.m_253186_((float)-162.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.875f, KeyframeAnimations.m_253186_((float)-180.0f, (float)-6.0f, (float)15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.0834334f, KeyframeAnimations.m_253186_((float)-180.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.2916765f, KeyframeAnimations.m_253186_((float)-180.0f, (float)-6.0f, (float)15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.5416765f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("left_arm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.375f, KeyframeAnimations.m_253186_((float)-162.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5834334f, KeyframeAnimations.m_253186_((float)-180.0f, (float)-7.3f, (float)-15.95f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.7916766f, KeyframeAnimations.m_253186_((float)-162.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-180.0f, (float)-7.3f, (float)-15.95f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.2083433f, KeyframeAnimations.m_253186_((float)-180.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.4167666f, KeyframeAnimations.m_253186_((float)-180.0f, (float)-7.3f, (float)-15.95f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.6766667f, KeyframeAnimations.m_253186_((float)-162.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.875f, KeyframeAnimations.m_253186_((float)-180.0f, (float)-7.3f, (float)-15.95f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.0834334f, KeyframeAnimations.m_253186_((float)-180.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.2916765f, KeyframeAnimations.m_253186_((float)-180.0f, (float)-7.3f, (float)-15.95f), AnimationChannel.Interpolations.f_232229_), new Keyframe(2.5416765f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();

    public ModelRaglok(EntityRendererProvider.Context context) {
        this.root = context.m_174023_(LAYER_LOCATION);
        this.head = this.root.m_171324_("head");
        this.body = this.root.m_171324_("body");
        this.right_arm = this.root.m_171324_("right_arm");
        this.left_arm = this.root.m_171324_("left_arm");
        this.right_wing = this.root.m_171324_("right_wing");
        this.left_wing = this.root.m_171324_("left_wing");
        this.portal = this.root.m_171324_("portal");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(54, 124).m_171488_(-7.0f, -14.0f, -7.0f, 14.0f, 14.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(54, 106).m_171488_(7.0f, -14.0f, -2.5f, 9.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(32, 13).m_171488_(11.0f, -22.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 40).m_171488_(-16.0f, -14.0f, -2.5f, 9.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-16.0f, -22.0f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(28, 44).m_171488_(1.0f, -17.0f, -8.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(41, 41).m_171488_(-4.0f, -17.0f, -8.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(32, 35).m_171488_(-4.0f, -17.0f, 5.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(32, 26).m_171488_(1.0f, -17.0f, 5.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(90, 88).m_171488_(-13.0f, -35.0f, -9.0f, 26.0f, 18.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(0, 106).m_171488_(-10.0f, -17.0f, -7.0f, 20.0f, 17.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(110, 124).m_171488_(0.0f, -3.0f, -4.0f, 8.0f, 32.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)13.0f, (float)-8.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -3.0f, -4.0f, 8.0f, 32.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-13.0f, (float)-8.0f, (float)0.0f));
        PartDefinition right_wing = partdefinition.m_171599_("right_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)7.0f, (float)-7.0f, (float)8.0f));
        PartDefinition right_wing_r1 = right_wing.m_171599_("right_wing_r1", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(0.0f, -3.0f, 1.0f, 0.0f, 26.0f, 54.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6545f, (float)1.0908f, (float)0.0f));
        PartDefinition left_wing = partdefinition.m_171599_("left_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)-7.0f, (float)8.0f));
        PartDefinition left_wing_r1 = left_wing.m_171599_("left_wing_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -3.0f, 1.0f, 0.0f, 26.0f, 54.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6545f, (float)-1.0908f, (float)0.0f));
        PartDefinition portal = partdefinition.m_171599_("portal", CubeListBuilder.m_171558_().m_171514_(17, 1).m_171488_(-24.0f, 0.0f, -23.0f, 47.0f, 0.0f, 47.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(@NotNull EntityRaglok entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f2 = 0.060000002f;
        float f1 = ageInTicks * 0.1f * 0.5f;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.left_wing.f_104205_ = -0.5235988f - Mth.m_14089_((float)f1) * f2;
        this.right_wing.f_104205_ = 0.5235988f + Mth.m_14089_((float)f1) * f2;
        float yrot = ageInTicks / 11.0f;
        if (ageInTicks <= 0.0f) {
            yrot = -ageInTicks / 11.0f;
        }
        this.portal.f_104203_ = 0.0f;
        this.portal.f_104204_ = yrot;
        this.portal.f_104205_ = 0.0f;
        if (entity.getAbility() == 5 || entity.getAbility() == 3) {
            this.right_arm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.left_arm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.right_arm.f_104205_ = -2.3561945f;
            this.left_arm.f_104205_ = 2.3561945f;
            this.head.f_104203_ = -0.35f;
        } else {
            this.left_arm.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * ((double)limbSwingAmount * 0.75) * 0.5);
            this.right_arm.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * ((double)limbSwingAmount * 0.75) * 0.5);
            this.right_arm.f_104205_ = 0.0f;
            this.left_arm.f_104205_ = 0.0f;
            this.head.f_104203_ = 0.0f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_wing.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_wing.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.portal.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

