/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class ModelSunstorm<T extends LivingEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("sunstorm");
    private final ModelPart UpperBody;
    private final ModelPart LowerBody;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart LeftLegThigh;
    private final ModelPart RightLegThigh;

    public ModelSunstorm(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.UpperBody = root.m_171324_("UpperBody");
        this.LowerBody = root.m_171324_("LowerBody");
        this.LeftArm = root.m_171324_("LeftArm");
        this.RightArm = root.m_171324_("RightArm");
        this.LeftLegThigh = root.m_171324_("LeftLegThigh");
        this.RightLegThigh = root.m_171324_("RightLegThigh");
    }

    public ModelSunstorm(ModelPart root) {
        this.UpperBody = root.m_171324_("UpperBody");
        this.LowerBody = root.m_171324_("LowerBody");
        this.LeftArm = root.m_171324_("LeftArm");
        this.RightArm = root.m_171324_("RightArm");
        this.LeftLegThigh = root.m_171324_("LeftLegThigh");
        this.RightLegThigh = root.m_171324_("RightLegThigh");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition UpperBody = partdefinition.m_171599_("UpperBody", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-12.0f, -23.0f, -6.0f, 24.0f, 22.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(84, 0).m_171488_(0.0f, -7.0f, -6.0f, 12.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(89, 57).m_171488_(1.0f, 1.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)12.0f, (float)-23.0f, (float)2.0f));
        LeftArm.m_171599_("LeftCannon", CubeListBuilder.m_171558_().m_171514_(47, 53).m_171488_(-5.0f, 0.0f, -4.0f, 10.0f, 22.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)10.0f, (float)-1.0f));
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(104, 103).m_171488_(-9.0f, 1.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(30, 86).m_171488_(-12.0f, -7.0f, -6.0f, 12.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-12.0f, (float)-23.0f, (float)2.0f));
        RightArm.m_171599_("RightCannon", CubeListBuilder.m_171558_().m_171514_(0, 64).m_171488_(-5.0f, 0.0f, -4.0f, 10.0f, 22.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)10.0f, (float)-1.0f));
        UpperBody.m_171599_("MiddleSoul", CubeListBuilder.m_171558_().m_171514_(61, 40).m_171488_(-3.0f, -8.0f, -1.0f, 6.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-28.0f, (float)-8.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        UpperBody.m_171599_("RightSoul", CubeListBuilder.m_171558_().m_171514_(45, 40).m_171488_(-3.0f, -8.0f, -1.0f, 6.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-10.0f, (float)-24.0f, (float)-8.0f, (float)-0.3491f, (float)0.0f, (float)-0.5236f));
        UpperBody.m_171599_("LeftSoul", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -8.0f, -1.0f, 6.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)10.0f, (float)-24.0f, (float)-8.0f, (float)-0.3491f, (float)0.0f, (float)0.5236f));
        UpperBody.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(34, 106).m_171488_(-6.0f, -8.0f, -4.0f, 12.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)-5.0f));
        partdefinition.m_171599_("LowerBody", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-8.0f, -2.0f, -4.0f, 16.0f, 11.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition RightLegThigh = partdefinition.m_171599_("RightLegThigh", CubeListBuilder.m_171558_().m_171514_(0, 98).m_171488_(-6.0f, 0.0f, -3.0f, 9.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-4.0f, (float)1.0f));
        RightLegThigh.m_171599_("RightLegFoot", CubeListBuilder.m_171558_().m_171514_(79, 76).m_171488_(-5.0f, 0.0f, -4.0f, 11.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)11.0f, (float)0.0f));
        PartDefinition LeftLegThigh = partdefinition.m_171599_("LeftLegThigh", CubeListBuilder.m_171558_().m_171514_(70, 103).m_171488_(-3.0f, 0.0f, -3.0f, 9.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-4.0f, (float)1.0f));
        LeftLegThigh.m_171599_("LeftLegFoot", CubeListBuilder.m_171558_().m_171514_(78, 30).m_171488_(-6.0f, 0.0f, -4.0f, 11.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.RightArm.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.LeftArm.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.RightArm.f_104204_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        AnimationUtils.m_170341_((ModelPart)this.RightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)this.LeftArm, (float)ageInTicks, (float)-1.0f);
        this.RightLegThigh.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.LeftLegThigh.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.setupAttackAnimation(entity, ageInTicks);
    }

    protected ModelPart getArm(HumanoidArm humanoidarm) {
        return this.RightArm;
    }

    private HumanoidArm getAttackArm(T p_102857_) {
        return p_102857_.m_5737_();
    }

    protected void setupAttackAnimation(T p_102858_, float p_102859_) {
        if (!(this.f_102608_ <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(p_102858_);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.f_102608_;
            this.UpperBody.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            this.RightArm.f_104204_ += this.UpperBody.f_104204_;
            f = 1.0f - this.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * 0.525f;
            modelpart.f_104203_ -= f1 * 1.2f + f2;
            modelpart.f_104204_ += this.UpperBody.f_104204_ * 2.0f;
            modelpart.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.UpperBody.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LowerBody.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLegThigh.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLegThigh.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

