/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Mob;

public class ModelPaleArcher<T extends Mob>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("pale_archer");
    public final ModelPart Head;
    public final ModelPart Torso;
    public final ModelPart LeftArm;
    public final ModelPart RightArm;
    public final ModelPart Trail;

    public ModelPaleArcher(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Head = root.m_171324_("Head");
        this.Torso = root.m_171324_("Torso");
        this.LeftArm = root.m_171324_("LeftArm");
        this.RightArm = root.m_171324_("RightArm");
        this.Trail = root.m_171324_("Trail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(28, 20).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-4.5f, -12.3f, -2.5f, 9.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)3.0f, (float)0.1565f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(24, 8).m_171488_(-4.0f, -12.0f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)1.0f, (float)0.0692f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(32, 36).m_171488_(0.0f, 0.0f, -2.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)3.0f, (float)1.0f));
        partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(24, 36).m_171488_(-2.0f, 0.0f, -2.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)3.0f, (float)1.0f));
        partdefinition.m_171599_("Trail", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-4.0f, 2.0f, 1.0f, 8.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f;
        this.Head.f_104204_ = netHeadYaw / 57.295776f;
        this.Head.f_104203_ = headPitch / 57.295776f;
        this.RightArm.f_104203_ = f = (float)Math.sqrt(Math.atan(200.0f * limbSwing)) * limbSwingAmount + 0.1565f;
        this.LeftArm.f_104203_ = f;
        this.RightArm.f_104204_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.2182f;
        this.LeftArm.f_104205_ = -0.2182f;
        AnimationUtils.m_170341_((ModelPart)this.RightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)this.LeftArm, (float)ageInTicks, (float)-1.0f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Trail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

