/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import org.jetbrains.annotations.NotNull;

public class ModelCadillion<T extends EntityDivineMonster>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("cadillion");
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart FrontRightLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart BackLeftLeg;

    public ModelCadillion(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Head = root.m_171324_("Head");
        this.Body = root.m_171324_("Body");
        this.FrontRightLeg = root.m_171324_("FrontRightLeg");
        this.FrontLeftLeg = root.m_171324_("FrontLeftLeg");
        this.BackRightLeg = root.m_171324_("BackRightLeg");
        this.BackLeftLeg = root.m_171324_("BackLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(33, 33).m_171488_(-4.0f, -5.8f, -5.7f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(54, 12).m_171488_(-3.0f, -2.8f, -8.7f, 6.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.8f, (float)-8.3f));
        Head.m_171599_("Horn_r1", CubeListBuilder.m_171558_().m_171514_(14, 56).m_171488_(-1.0f, -7.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.7528f, (float)-4.4743f, (float)0.3927f, (float)0.0f, (float)0.0f));
        Head.m_171599_("RightEar_r1", CubeListBuilder.m_171558_().m_171514_(55, 31).m_171488_(0.0f, -6.47f, 1.0f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(38, 56).m_171488_(0.0f, -6.47f, 0.99f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)-2.8f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        ModelCadillion.addEars(Head);
        partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-4.0f, -4.5f, -8.75f, 8.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-5.5f, -5.5f, -9.25f, 11.0f, 12.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.5f, (float)0.75f));
        ModelCadillion.addLegs(partdefinition);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public static void addEars(PartDefinition head) {
        head.m_171599_("LeftEar_r1", CubeListBuilder.m_171558_().m_171514_(1, 56).m_171488_(-1.0f, -7.0f, 1.0f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(22, 56).m_171488_(-1.0f, -7.0f, 0.99f, 6.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-2.8f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)0.1309f));
        head.m_171599_("Mouth", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-3.0f, -0.5f, -1.5f, 6.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.7f, (float)-7.2f));
    }

    public static void addLegs(PartDefinition partdefinition) {
        partdefinition.m_171599_("FrontRightLeg", CubeListBuilder.m_171558_().m_171514_(50, 50).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)-6.0f));
        partdefinition.m_171599_("FrontLeftLeg", CubeListBuilder.m_171558_().m_171514_(41, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)13.0f, (float)-6.0f));
        partdefinition.m_171599_("BackRightLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)8.0f));
        partdefinition.m_171599_("BackLeftLeg", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)13.0f, (float)8.0f));
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104204_ = netHeadYaw / 57.295776f;
        this.Head.f_104203_ = headPitch / 57.295776f;
        this.FrontLeftLeg.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount);
        double v = Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)limbSwingAmount;
        this.FrontRightLeg.f_104203_ = (float)v;
        this.BackLeftLeg.f_104203_ = (float)v;
        this.BackRightLeg.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ModelCadillion.renderEverything(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha, this.Head, this.Body, this.FrontRightLeg, this.FrontLeftLeg, this.BackRightLeg, this.BackLeftLeg);
    }

    public static void renderEverything(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, ModelPart head, ModelPart body, ModelPart frontRightLeg, ModelPart frontLeftLeg, ModelPart backRightLeg, ModelPart backLeftLeg) {
        head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        frontRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        frontLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        backRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        backLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

