/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.eden.EntityMadivel;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelMadivel
extends EntityModel<EntityMadivel> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("madivel");
    private final ModelPart Spine;
    private final ModelPart Sun1;
    private final ModelPart Sun2;
    private final ModelPart EdenSpirit;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;

    public ModelMadivel(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Spine = root.m_171324_("Spine");
        this.Sun1 = root.m_171324_("Sun1");
        this.Sun2 = root.m_171324_("Sun2");
        this.RightLeg = root.m_171324_("RightLeg");
        this.LeftLeg = root.m_171324_("LeftLeg");
        this.RightArm = root.m_171324_("RightArm");
        this.LeftArm = root.m_171324_("LeftArm");
        this.EdenSpirit = root.m_171324_("EdenSpirit");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("Spine", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -20.0f, -8.0f, 18.0f, 19.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(54, 0).m_171488_(-5.5f, -1.0f, -5.0f, 11.0f, 5.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 37).m_171488_(-9.0f, -27.0f, -6.0f, 18.0f, 7.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(72, 17).m_171488_(-5.0f, -26.0f, -4.0f, 10.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(137, 0).m_171488_(-5.0f, 1.0f, -3.0f, 4.0f, 21.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(88, 36).m_171488_(1.0f, 1.0f, -3.0f, 4.0f, 21.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(100, 97).m_171488_(0.0f, -2.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(26, 88).m_171488_(1.0f, 6.0f, -3.0f, 6.0f, 20.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-14.0f, (float)2.0f));
        partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-8.0f, -2.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(84, 79).m_171488_(-7.0f, 6.0f, -3.0f, 6.0f, 20.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.0f, (float)-14.0f, (float)2.0f));
        partdefinition.m_171599_("Sun1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(7.5f, -4.5f, 0.25f, 9.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(101, 16).m_171488_(9.5f, -2.5f, -2.75f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-32.5f, (float)1.75f));
        partdefinition.m_171599_("Sun2", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-17.5f, -4.5f, 0.25f, 9.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 93).m_171488_(-15.5f, -2.5f, -2.75f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-32.5f, (float)1.75f));
        PartDefinition EdenSpirit = partdefinition.m_171599_("EdenSpirit", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-1.5f, -5.0f, -2.25f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 37).m_171488_(-1.5f, -8.0f, -0.25f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-28.0f, (float)2.25f));
        EdenSpirit.m_171599_("EdenSpiritHead", CubeListBuilder.m_171558_().m_171514_(0, 103).m_171488_(-2.5f, -5.25f, -4.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(24, 58).m_171488_(-4.0f, -7.25f, -2.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.75f, (float)0.75f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(EntityMadivel entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.EdenSpirit.f_104204_ = netHeadYaw / 57.295776f;
        this.EdenSpirit.f_104203_ = headPitch / 57.295776f;
        float orbitRadius = 2.0f;
        float orbitSpeed = 0.1f;
        float sun1OrbitAngle = ageInTicks * orbitSpeed;
        float sun1OffsetX = (float)(Math.cos(sun1OrbitAngle) * (double)orbitRadius);
        float sun1OffsetZ = (float)(Math.sin(sun1OrbitAngle) * (double)orbitRadius);
        this.Sun1.f_104200_ = this.EdenSpirit.f_104200_ + sun1OffsetX;
        this.Sun1.f_104202_ = this.EdenSpirit.f_104202_ + sun1OffsetZ;
        float sun2OrbitAngle = ageInTicks * orbitSpeed * 0.8f;
        float sun2OffsetX = (float)(Math.cos(sun2OrbitAngle) * (double)orbitRadius);
        float sun2OffsetZ = (float)(Math.sin(sun2OrbitAngle) * (double)orbitRadius);
        this.Sun2.f_104200_ = this.EdenSpirit.f_104200_ + sun2OffsetX;
        this.Sun2.f_104202_ = this.EdenSpirit.f_104202_ + sun2OffsetZ;
        this.RightArm.f_104204_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        AnimationUtils.m_170341_((ModelPart)this.RightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)this.LeftArm, (float)ageInTicks, (float)-1.0f);
        this.RightLeg.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.LeftLeg.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
    }

    public void prepareMobModel(EntityMadivel entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        super.m_6839_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks);
        float healthFraction = entity.m_21223_() / entity.m_21233_();
        if ((double)healthFraction < 0.3333333333333333) {
            this.Sun1.f_104207_ = false;
            this.Sun2.f_104207_ = false;
        } else if ((double)healthFraction < 0.6666666666666666) {
            this.Sun1.f_104207_ = false;
            this.Sun2.f_104207_ = true;
        } else {
            this.Sun1.f_104207_ = true;
            this.Sun2.f_104207_ = true;
        }
        int i = entity.getAttackAnimationTick();
        if (i > 0) {
            this.RightArm.f_104203_ = -1.5f + 1.5f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f);
            this.LeftArm.f_104203_ = -1.5f + 1.5f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f);
        } else {
            this.RightArm.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
            this.LeftArm.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Spine.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Sun1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Sun2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.EdenSpirit.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

