/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.wildwood.EntityMoonWolf;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelMoonWolf<T extends EntityMoonWolf>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("moon_wolf");
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart BackLeftLeg;
    private final ModelPart FrontRightLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart Tail;

    public ModelMoonWolf(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Body = root.m_171324_("Body");
        this.Head = root.m_171324_("Head");
        this.BackLeftLeg = root.m_171324_("BackLeftLeg");
        this.FrontRightLeg = root.m_171324_("FrontRightLeg");
        this.FrontLeftLeg = root.m_171324_("FrontLeftLeg");
        this.BackRightLeg = root.m_171324_("BackRightLeg");
        this.Tail = root.m_171324_("Tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)11.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        Head.m_171599_("RightEar_r1", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.0f, -5.0f, -1.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-3.0f, (float)-1.5f, (float)0.1745f, (float)0.5236f, (float)0.0f));
        Head.m_171599_("LeftEar_r1", CubeListBuilder.m_171558_().m_171514_(13, 18).m_171488_(0.0f, -5.0f, -1.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-3.0f, (float)-1.5f, (float)0.1745f, (float)-0.5236f, (float)0.0f));
        Head.m_171599_("HeadBase_r1", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.5f, -3.0f, -3.5f, 3.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-4.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        Head.m_171599_("Hair_r1", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-2.0f, -20.5f, -1.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)5.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        Body.m_171599_("BodyBase", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-3.0f, -6.0f, -6.01f, 6.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -6.0f, -6.0f, 6.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("BackLeftLeg", CubeListBuilder.m_171558_().m_171514_(20, 18).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)15.0f, (float)5.0f));
        partdefinition.m_171599_("FrontRightLeg", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)15.0f, (float)-5.0f));
        partdefinition.m_171599_("FrontLeftLeg", CubeListBuilder.m_171558_().m_171514_(26, 27).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)15.0f, (float)-5.0f));
        partdefinition.m_171599_("BackRightLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)15.0f, (float)5.0f));
        PartDefinition Tail = partdefinition.m_171599_("Tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)6.0f));
        PartDefinition LeftTail = Tail.m_171599_("LeftTail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)2.0f));
        LeftTail.m_171599_("LeftTail_r1", CubeListBuilder.m_171558_().m_171514_(48, -8).m_171488_(1.0f, -7.0f, -1.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.384f, (float)0.2007f, (float)0.1658f));
        PartDefinition RightTail = Tail.m_171599_("RightTail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)2.0f));
        RightTail.m_171599_("RightTail_r1", CubeListBuilder.m_171558_().m_171514_(48, 2).m_171488_(-1.0f, -7.0f, -1.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.384f, (float)-0.2007f, (float)-0.1658f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(EntityMoonWolf entity, float limbSwing, float limbSwingAmount, float p_102617_) {
        this.Tail.f_104204_ = entity.m_21660_() ? 0.0f : Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (entity.m_21825_()) {
            this.Head.m_104227_(0.0f, 12.0f, -2.0f);
            this.Body.m_104227_(0.0f, 20.0f, -2.0f);
            this.Body.f_104203_ = -0.7853982f;
            this.Tail.m_104227_(0.0f, 21.0f, 6.0f);
            this.BackRightLeg.m_104227_(-1.95f, 23.0f, 2.0f);
            this.BackRightLeg.f_104203_ = 4.712389f;
            this.BackLeftLeg.m_104227_(1.95f, 23.0f, 2.0f);
            this.BackLeftLeg.f_104203_ = 4.712389f;
            this.FrontRightLeg.f_104203_ = 5.811947f;
            this.FrontRightLeg.m_104227_(-1.9375f, 15.0f, -4.0f);
            this.FrontLeftLeg.f_104203_ = 5.811947f;
            this.FrontLeftLeg.m_104227_(1.9375f, 15.0f, -4.0f);
        } else {
            this.Head.m_104227_(0.0f, 11.0f, -5.0f);
            this.Body.m_104227_(0.0f, 15.0f, 0.0f);
            this.Body.f_104203_ = 0.0f;
            this.Tail.m_104227_(0.0f, 10.0f, 6.0f);
            this.BackRightLeg.m_104227_(-2.0f, 15.0f, 5.0f);
            this.BackLeftLeg.m_104227_(2.0f, 15.0f, 5.0f);
            this.FrontRightLeg.m_104227_(-2.0f, 15.0f, -5.0f);
            this.FrontLeftLeg.m_104227_(2.0f, 15.0f, -5.0f);
            this.BackRightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.BackLeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.FrontRightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.FrontLeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        this.Head.f_104205_ = entity.m_30448_(p_102617_) + entity.m_30432_(p_102617_, 0.0f);
        this.Body.f_104205_ = entity.m_30432_(p_102617_, -0.16f);
        this.Tail.f_104205_ = entity.m_30432_(p_102617_, -0.2f);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.BackRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.BackLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.FrontRightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.FrontLeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

