/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelTwilightGolem<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("twilight_golem");
    private final ModelPart torso;
    private final ModelPart body;
    private final ModelPart headLeft;
    private final ModelPart headRight;
    private final ModelPart rightShoulder;
    private final ModelPart rightArm;
    private final ModelPart rightHand;
    private final ModelPart leftShoulder;
    private final ModelPart leftArm;
    private final ModelPart leftHand;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public ModelTwilightGolem(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.torso = root.m_171324_("torso");
        this.body = root.m_171324_("body");
        this.headLeft = root.m_171324_("headLeft");
        this.headRight = root.m_171324_("headRight");
        this.rightShoulder = root.m_171324_("rightShoulder");
        this.rightArm = root.m_171324_("rightArm");
        this.rightHand = root.m_171324_("rightHand");
        this.leftShoulder = root.m_171324_("leftShoulder");
        this.leftArm = root.m_171324_("leftArm");
        this.leftHand = root.m_171324_("leftHand");
        this.rightLeg = root.m_171324_("rightLeg");
        this.leftLeg = root.m_171324_("leftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-8.0f, (float)-8.0f, (float)-4.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 20.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-10.0f, (float)-20.0f, (float)-6.0f));
        partdefinition.m_171599_("headLeft", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171480_().m_171488_(-4.0f, -5.0f, -8.0f, 7.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-20.0f, (float)-2.0f));
        partdefinition.m_171599_("headRight", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171480_().m_171488_(-4.0f, -5.0f, -8.0f, 7.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)-20.0f, (float)-2.0f));
        partdefinition.m_171599_("rightShoulder", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-12.0f, (float)-20.0f, (float)0.0f));
        partdefinition.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(30, 44).m_171480_().m_171488_(-2.0f, 3.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-12.0f, (float)-20.0f, (float)0.0f));
        partdefinition.m_171599_("rightHand", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(-3.0f, 19.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-12.0f, (float)-20.0f, (float)0.0f));
        partdefinition.m_171599_("leftShoulder", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)12.0f, (float)-20.0f, (float)0.0f));
        partdefinition.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(30, 44).m_171480_().m_171488_(-2.0f, 3.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)12.0f, (float)-20.0f, (float)0.0f));
        partdefinition.m_171599_("leftHand", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(-3.0f, 19.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)12.0f, (float)-20.0f, (float)0.0f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(46, 40).m_171480_().m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)8.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(46, 40).m_171480_().m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headLeft.f_104203_ = this.headRight.f_104203_ = headPitch / 57.295776f;
        this.headLeft.f_104204_ = this.headRight.f_104204_ = netHeadYaw / 57.295776f;
        this.rightArm.f_104203_ = this.rightShoulder.f_104203_ = Mth.m_14089_((float)limbSwing) * limbSwingAmount;
        this.rightHand.f_104203_ = this.rightShoulder.f_104203_;
        this.leftLeg.f_104203_ = this.rightShoulder.f_104203_;
        this.leftArm.f_104203_ = this.leftShoulder.f_104203_ = Mth.m_14089_((float)(limbSwing + (float)Math.PI)) * limbSwingAmount * 0.7f;
        this.leftHand.f_104203_ = this.leftShoulder.f_104203_;
        this.rightLeg.f_104203_ = this.leftShoulder.f_104203_;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.headLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.headRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightShoulder.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightHand.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftShoulder.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftHand.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

