/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Mob;

public class ModelAridWarrior<T extends Mob>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("arid_warrior");
    public final ModelPart Torso;
    public final ModelPart Cape;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart Head;

    public ModelAridWarrior(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Torso = root.m_171324_("Torso");
        this.Cape = this.Torso.m_171324_("Cape");
        this.rightLeg = root.m_171324_("rightLeg");
        this.leftLeg = root.m_171324_("leftLeg");
        this.rightArm = root.m_171324_("rightArm");
        this.leftArm = root.m_171324_("leftArm");
        this.Head = root.m_171324_("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Torso = partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-5.0f, -10.0f, -3.0f, 10.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        Head.m_171599_("rightear_r1", CubeListBuilder.m_171558_().m_171514_(29, 46).m_171488_(0.0f, -5.0f, 0.0f, 0.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        Head.m_171599_("leftear_r1", CubeListBuilder.m_171558_().m_171514_(41, 46).m_171488_(0.0872f, -5.0f, -0.0019f, 0.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        Torso.m_171599_("Cape", CubeListBuilder.m_171558_().m_171514_(31, 31).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)3.0f));
        partdefinition.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(17, 46).m_171488_(-3.0f, -1.0f, -1.5f, 3.0f, 14.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-1.0f, (float)0.5f));
        partdefinition.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(8, 32).m_171488_(0.0f, -1.0f, -1.5f, 3.0f, 14.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-1.0f, (float)0.5f));
        Torso.m_171599_("Hip", CubeListBuilder.m_171558_().m_171514_(27, 11).m_171488_(-5.0f, 0.0f, -2.0f, 10.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-2.5f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        rightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(32, 20).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(48, 20).m_171488_(-1.5f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        leftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)5.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104204_ = netHeadYaw / 57.295776f;
        this.Head.f_104203_ = headPitch / 57.295776f;
        this.rightArm.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.leftArm.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.rightArm.f_104204_ = 0.0f;
        this.leftArm.f_104204_ = 0.0f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        AnimationUtils.m_170341_((ModelPart)this.rightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)this.leftArm, (float)ageInTicks, (float)-1.0f);
        this.rightLeg.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.leftLeg.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        float capeMov = (float)Math.sqrt(Math.atan(200.0f * limbSwing)) * limbSwingAmount;
        this.Cape.f_104203_ = capeMov + 0.17453294f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

