/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityDesertCrawler;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;

public class ModelDesertCrawler
extends EntityModel<EntityDesertCrawler> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("desert_crawler");
    private final ModelPart spine;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart bb_main;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart skull;

    public ModelDesertCrawler(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.spine = root.m_171324_("spine");
        this.rightLeg = root.m_171324_("rightfullleg");
        this.leftLeg = root.m_171324_("leftfullleg");
        this.bb_main = root.m_171324_("bb_main");
        this.rightArm = root.m_171324_("rightfullarm");
        this.leftArm = root.m_171324_("leftfullarm");
        this.skull = root.m_171324_("skull");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("spine", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -4.0f, -4.0f, 8.0f, 6.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)-0.5f));
        partdefinition.m_171599_("skull", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(24, 18).m_171488_(-4.0f, -8.0f, -1.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(30, 18).m_171488_(-4.01f, -8.0f, -1.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(44, 46).m_171488_(4.0f, 1.0f, -6.0f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(42, 37).m_171488_(-5.0f, 1.0f, -6.0f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(24, 22).m_171488_(4.0f, -8.0f, -1.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(30, 22).m_171488_(4.01f, -8.0f, -1.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-8.0f));
        partdefinition.m_171599_("leftfullarm", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)16.0f, (float)-5.5f));
        partdefinition.m_171599_("rightfullarm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)16.0f, (float)-5.5f));
        partdefinition.m_171599_("rightfullleg", CubeListBuilder.m_171558_().m_171514_(24, 31).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(16, 43).m_171488_(-5.0f, 2.0f, 3.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)15.0f, (float)3.0f));
        partdefinition.m_171599_("leftfullleg", CubeListBuilder.m_171558_().m_171514_(33, 0).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(30, 43).m_171488_(1.0f, 2.0f, 3.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)15.0f, (float)3.0f));
        partdefinition.m_171599_("bb_main", CubeListBuilder.m_171558_().m_171514_(40, 23).m_171488_(-4.0f, -14.0f, -11.0f, 8.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(EntityDesertCrawler entity, float limbSwing, float limbSwingAmount, float p_102617_) {
        super.m_6839_((Entity)entity, limbSwing, limbSwingAmount, p_102617_);
        if (!entity.hasSeen()) {
            this.spine.m_104227_(-1.0f, 14.0f, -4.0f);
            this.spine.f_104203_ = 5.6089935f;
            this.rightLeg.m_104227_(-2.5f, 18.0f, 4.0f);
            this.rightLeg.f_104203_ = 4.712389f;
            this.leftLeg.m_104227_(2.5f, 18.0f, 4.0f);
            this.leftLeg.f_104203_ = 4.712389f;
            this.rightArm.f_104203_ = 5.811947f;
            this.rightArm.m_104227_(-4.0f, 14.0f, -4.0f);
            this.leftArm.f_104203_ = 5.811947f;
            this.leftArm.m_104227_(4.0f, 14.0f, -4.0f);
        } else {
            this.rightLeg.m_104227_(-2.5f, 15.0f, 5.0f);
            this.leftLeg.m_104227_(2.5f, 15.0f, 5.0f);
            this.rightArm.m_104227_(-4.0f, 14.0f, -4.0f);
            this.leftArm.m_104227_(4.0f, 14.0f, -4.0f);
            this.spine.m_104227_(-1.0f, 14.0f, -3.0f);
            this.spine.f_104203_ = (float)Math.PI * 8;
            this.leftArm.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
            this.leftLeg.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
            this.rightArm.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
            this.rightLeg.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        }
    }

    public void setupAnim(EntityDesertCrawler entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.skull.f_104204_ = netHeadYaw / 57.295776f;
        this.skull.f_104203_ = headPitch / 57.295776f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.spine.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bb_main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.skull.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

