/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityGlacon;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelGlacon
extends EntityModel<EntityGlacon> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("glacon");
    private final ModelPart Spine;
    private final ModelPart Head;
    private final ModelPart RightFrontLeg;
    private final ModelPart RightMiddleLeg;
    private final ModelPart RightRearLeg;
    private final ModelPart LeftFrontLeg;
    private final ModelPart LeftMiddleLeg;
    private final ModelPart LeftRearLeg;

    public ModelGlacon(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Spine = root.m_171324_("Spine");
        this.Head = root.m_171324_("Head");
        this.RightFrontLeg = root.m_171324_("RightLegFront");
        this.RightMiddleLeg = root.m_171324_("RightLegMiddle");
        this.RightRearLeg = root.m_171324_("RightLegBack");
        this.LeftFrontLeg = root.m_171324_("LeftLegFront");
        this.LeftMiddleLeg = root.m_171324_("LeftLegMiddle");
        this.LeftRearLeg = root.m_171324_("LeftLegBack");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Spine = partdefinition.m_171599_("Spine", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)-1.0f));
        Spine.m_171599_("Hip", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -3.5f, -3.0f, 8.0f, 7.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)-3.0f));
        partdefinition.m_171599_("RightLegBack", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)12.0f, (float)9.0f));
        partdefinition.m_171599_("LeftLegBack", CubeListBuilder.m_171558_().m_171514_(16, 56).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)12.0f, (float)9.0f));
        partdefinition.m_171599_("LeftLegMiddle", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)12.0f, (float)3.0f));
        partdefinition.m_171599_("RightLegMiddle", CubeListBuilder.m_171558_().m_171514_(32, 59).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)12.0f, (float)3.0f));
        PartDefinition Body = Spine.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(-6.0f, -8.0f, -8.0f, 12.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 73).m_171488_(-2.0f, 1.0f, -8.0f, 4.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        Body.m_171599_("LeftSmallSail", CubeListBuilder.m_171558_().m_171514_(76, 15).m_171488_(0.0f, -8.0f, -1.0f, 0.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(100, 15).m_171488_(0.01f, -8.0f, -1.0f, 0.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-8.0f, (float)-3.0f));
        Body.m_171599_("RightSmallSail", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(0.0f, -8.0f, -1.0f, 0.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(68, 0).m_171488_(-0.01f, -8.0f, -1.0f, 0.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-8.0f, (float)-3.0f));
        Body.m_171599_("RightSail", CubeListBuilder.m_171558_().m_171514_(0, 78).m_171488_(0.0f, -9.0f, -2.0f, 0.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(30, 78).m_171488_(0.01f, -9.0f, -2.0f, 0.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-9.0f, (float)-6.0f));
        Body.m_171599_("LeftSail", CubeListBuilder.m_171558_().m_171514_(0, 68).m_171488_(0.0f, -9.0f, -2.0f, 0.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(30, 68).m_171488_(-0.01f, -9.0f, -2.0f, 0.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-9.0f, (float)-6.0f));
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(47, 47).m_171488_(-3.0f, -3.5f, -8.5f, 6.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.5f, (float)-12.5f));
        Head.m_171599_("RightWhisker", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(38, 0).m_171488_(-4.5f, -2.5f, -0.01f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)2.0f, (float)-7.5f));
        Head.m_171599_("LeftWhisker", CubeListBuilder.m_171558_().m_171514_(10, 16).m_171488_(-0.5f, -2.5f, 0.0f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(48, 0).m_171488_(-0.5f, -2.5f, -0.01f, 5.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)2.0f, (float)-7.5f));
        partdefinition.m_171599_("LeftLegFront", CubeListBuilder.m_171558_().m_171514_(48, 63).m_171488_(-2.0f, -0.5f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)12.5f, (float)-5.0f));
        partdefinition.m_171599_("RightLegFront", CubeListBuilder.m_171558_().m_171514_(60, 22).m_171488_(-2.0f, -0.5f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)12.5f, (float)-5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityGlacon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.RightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.RightRearLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.RightMiddleLeg.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + 1.0E-6) * (double)1.4f * (double)limbSwingAmount);
        this.LeftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.LeftMiddleLeg.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f + 3.141594f) * (double)1.4f * (double)limbSwingAmount);
        this.LeftRearLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Spine.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightMiddleLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightRearLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftMiddleLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftRearLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

