/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityRainbour;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelRainbour
extends EntityModel<EntityRainbour> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("rainbour");
    public final ModelPart body;
    public final ModelPart tail1;
    public final ModelPart tail2;
    public final ModelPart head;
    public final ModelPart lwing1;
    public final ModelPart lwing2;
    public final ModelPart lwing3;
    public final ModelPart rwing1;
    public final ModelPart rwing2;
    public final ModelPart rwing3;
    public final ModelPart lhip;
    public final ModelPart rhip;

    public ModelRainbour(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.body = root.m_171324_("body");
        this.tail1 = root.m_171324_("tail1");
        this.tail2 = this.tail1.m_171324_("tail2");
        this.head = root.m_171324_("head");
        this.lwing1 = root.m_171324_("lwing1");
        this.lwing2 = this.lwing1.m_171324_("lwing2");
        this.lwing3 = this.lwing2.m_171324_("lwing3");
        this.rwing1 = root.m_171324_("rwing1");
        this.rwing2 = this.rwing1.m_171324_("rwing2");
        this.rwing3 = this.rwing2.m_171324_("rwing3");
        this.lhip = root.m_171324_("lhip");
        this.rhip = root.m_171324_("rhip");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171480_().m_171488_(-3.0f, 1.0f, 1.0f, 6.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(-4.0f, -4.0f, 0.0f, 8.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)-5.0f));
        PartDefinition tail1 = partdefinition.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(48, 50).m_171480_().m_171488_(-3.0f, -2.5f, 0.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(49, 40).m_171480_().m_171488_(-2.0f, -2.0f, 5.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)5.5f));
        tail1.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(68, 41).m_171480_().m_171488_(-1.5f, -2.5f, 0.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(73, 52).m_171480_().m_171488_(-5.5f, -1.0f, 4.0f, 11.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)9.5f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(34, 41).m_171480_().m_171488_(-2.0f, -1.2f, -7.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 27).m_171480_().m_171488_(-3.0f, -2.0f, -5.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)12.5f, (float)-5.0f));
        head.m_171599_("lhorn1_r1", CubeListBuilder.m_171558_().m_171514_(24, 27).m_171480_().m_171488_(-0.5f, -4.0f, -3.5f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(25, 34).m_171480_().m_171488_(-0.5f, -6.0f, -2.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(30, 34).m_171480_().m_171488_(-6.5f, -6.0f, -2.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(30, 27).m_171480_().m_171488_(-6.5f, -4.0f, -3.5f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        head.m_171599_("hornything_r1", CubeListBuilder.m_171558_().m_171514_(49, 0).m_171480_().m_171488_(-1.0f, -8.9f, -19.8f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)5.0f, (float)-0.8029f, (float)0.0f, (float)0.0f));
        PartDefinition lwing1 = partdefinition.m_171599_("lwing1", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(0.0f, 0.0f, -2.0f, 9.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.0f, (float)12.0f, (float)-3.0f, (float)0.0f, (float)-0.3665f, (float)0.0f));
        PartDefinition lwing2 = lwing1.m_171599_("lwing2", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171480_().m_171488_(4.0f, 0.0f, 0.0f, 8.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-0.01f, (float)0.0f, (float)0.0f, (float)0.5585f, (float)0.0f));
        lwing2.m_171599_("lwing3", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171480_().m_171488_(11.0f, 0.0f, -5.0f, 14.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.44f, (float)-0.01f, (float)-0.5f, (float)0.0f, (float)-0.4538f, (float)0.0f));
        PartDefinition rwing1 = partdefinition.m_171599_("rwing1", CubeListBuilder.m_171558_().m_171514_(33, 18).m_171480_().m_171488_(-9.0f, 0.0f, -2.0f, 9.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)12.0f, (float)-3.0f, (float)0.0f, (float)0.3665f, (float)0.0f));
        PartDefinition rwing2 = rwing1.m_171599_("rwing2", CubeListBuilder.m_171558_().m_171514_(38, 28).m_171480_().m_171488_(-12.0f, 0.0f, 0.0f, 8.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-0.01f, (float)0.0f, (float)0.0f, (float)-0.5585f, (float)0.0f));
        rwing2.m_171599_("rwing3", CubeListBuilder.m_171558_().m_171514_(66, 15).m_171480_().m_171488_(-25.0f, 0.0f, -5.0f, 14.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.44f, (float)-0.01f, (float)-0.5f, (float)0.0f, (float)0.4538f, (float)0.0f));
        PartDefinition lhip = partdefinition.m_171599_("lhip", CubeListBuilder.m_171558_().m_171514_(73, 28).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.0f, (float)15.0f, (float)2.0f));
        lhip.m_171599_("lfoot_r1", CubeListBuilder.m_171558_().m_171514_(56, 12).m_171480_().m_171488_(2.5f, -10.5f, 2.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)15.0f, (float)-2.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        lhip.m_171599_("lthigh", CubeListBuilder.m_171558_().m_171514_(99, 29).m_171480_().m_171488_(-1.0f, 3.0f, -3.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7679f, (float)0.0f, (float)0.0f));
        PartDefinition rhip = partdefinition.m_171599_("rhip", CubeListBuilder.m_171558_().m_171514_(86, 28).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)15.0f, (float)2.0f));
        rhip.m_171599_("rfoot_r1", CubeListBuilder.m_171558_().m_171514_(61, 12).m_171480_().m_171488_(-3.5f, -10.5f, 2.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.0f, (float)15.0f, (float)-2.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        rhip.m_171599_("rthigh", CubeListBuilder.m_171558_().m_171514_(39, 1).m_171480_().m_171488_(-1.0f, 3.0f, -3.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7679f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(EntityRainbour entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float t;
        this.head.f_104203_ = headPitch / 60.0f;
        this.head.f_104204_ = netHeadYaw / 60.0f;
        if (!entity.m_20096_()) {
            this.rhip.f_104203_ = 0.3927f;
            this.lhip.f_104203_ = 0.3927f;
        } else {
            this.lhip.f_104203_ = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount) - 0.227f;
            this.rhip.f_104203_ = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount) - 0.227f;
        }
        this.rwing1.f_104205_ = (float)(Math.cos(ageInTicks * 0.3f) * Math.PI * (double)0.3f);
        this.lwing1.f_104205_ = (float)(Math.cos(ageInTicks * 0.3f) * Math.PI * (double)-0.3f);
        this.tail1.f_104203_ = t = (float)(Math.cos(limbSwing * 0.3f) * (double)limbSwingAmount / 2.0);
        this.tail2.f_104203_ = t * 2.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.lwing1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rwing1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.lhip.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rhip.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

