/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.valoria.EntityTaintedKnight;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelTaintedKnight<T extends EntityTaintedKnight>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("tainted_knight");
    private final ModelPart Head;
    private final ModelPart helmet;
    private final ModelPart Body;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;

    public ModelTaintedKnight(EntityRendererProvider.Context context) {
        ModelPart root = context.m_174023_(LAYER_LOCATION);
        this.Head = root.m_171324_("Head");
        this.helmet = this.Head.m_171324_("helmet");
        this.Body = root.m_171324_("Body");
        this.RightArm = root.m_171324_("RightArm");
        this.LeftArm = root.m_171324_("LeftArm");
        this.RightLeg = root.m_171324_("RightLeg");
        this.LeftLeg = root.m_171324_("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(32, 32).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition helmet = Head.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -24.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)).m_171514_(0, 32).m_171488_(-4.0f, -27.0f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 43).m_171488_(4.0f, -27.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 43).m_171480_().m_171488_(-8.0f, -27.0f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(40, 0).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 48).m_171480_().m_171488_(-3.5f, -4.0f, -1.5f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 48).m_171480_().m_171488_(-3.5f, -4.0f, 1.5f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 48).m_171488_(1.0f, -4.0f, -1.5f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 48).m_171488_(1.0f, -4.0f, 1.5f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityTaintedKnight entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((Boolean)entity.m_20088_().m_135370_(EntityTaintedKnight.HAS_HELMET)).booleanValue()) {
            this.helmet.f_233553_ = 0.0f;
            this.helmet.f_233554_ = 0.0f;
            this.helmet.f_233555_ = 0.0f;
        } else {
            this.helmet.f_233553_ = 1.0f;
            this.helmet.f_233554_ = 1.0f;
            this.helmet.f_233555_ = 1.0f;
        }
        this.Head.f_104204_ = netHeadYaw / 57.295776f;
        this.Head.f_104203_ = headPitch / 57.295776f;
        this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount * 0.5f;
        this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount * 0.5f;
        this.RightArm.f_104205_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.RightLeg.f_104204_ = 0.0f;
        this.LeftLeg.f_104204_ = 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

