/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.particle.options;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class ParticleColouredType
extends ParticleType<ParticleColour> {
    public static final Codec<ParticleColour> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("particle_type").forGetter(data -> ForgeRegistries.PARTICLE_TYPES.getKey(data.particleType).toString()), (App)Codec.INT.fieldOf("red0").forGetter(data -> data.red), (App)Codec.INT.fieldOf("green0").forGetter(data -> data.green), (App)Codec.INT.fieldOf("blue0").forGetter(data -> data.blue)).apply((Applicative)instance, (type, red, green, blue) -> new ParticleColour((ParticleType<ParticleColour>)((ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(type))), (int)red, (int)green, (int)blue)));

    public ParticleColouredType(boolean alwaysShow) {
        super(alwaysShow, ParticleColour.DESERIALIZER);
    }

    public Codec<ParticleColour> m_7652_() {
        return CODEC;
    }

    public static class ParticleColour
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<ParticleColour> DESERIALIZER = new ParticleOptions.Deserializer<ParticleColour>(){

            public ParticleColour fromCommand(ParticleType<ParticleColour> particleType, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int red = reader.readInt();
                reader.expect(' ');
                int green = reader.readInt();
                reader.expect(' ');
                int blue = reader.readInt();
                reader.expect(' ');
                return new ParticleColour(particleType, red, green, blue);
            }

            public ParticleColour fromNetwork(ParticleType<ParticleColour> particleType, FriendlyByteBuf buffer) {
                return new ParticleColour(particleType, buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        };
        private final ParticleType<ParticleColour> particleType;
        private final int red;
        private final int green;
        private final int blue;

        public ParticleColour(ParticleType<ParticleColour> particleType, int red, int green, int blue) {
            this.particleType = particleType;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s Colour: %d %d %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.red, this.green, this.blue);
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.red);
            buffer.writeInt(this.green);
            buffer.writeInt(this.blue);
        }

        public ParticleType<?> m_6012_() {
            return this.particleType;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getRed() {
            return this.red;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getGreen() {
            return this.green;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getBlue() {
            return this.blue;
        }
    }
}

