/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import divinerpg.block_entities.bosses.StatueBlockEntity;
import divinerpg.blocks.base.BlockStatue;
import divinerpg.client.models.boss.ModelAncientEntity;
import divinerpg.client.models.boss.ModelAyeraco;
import divinerpg.client.models.boss.ModelDensos;
import divinerpg.client.models.boss.ModelDramix;
import divinerpg.client.models.boss.ModelEternalArcher;
import divinerpg.client.models.boss.ModelExperiencedCori;
import divinerpg.client.models.boss.ModelKarot;
import divinerpg.client.models.boss.ModelKingOfScorchers;
import divinerpg.client.models.boss.ModelKitra;
import divinerpg.client.models.boss.ModelParasecta;
import divinerpg.client.models.boss.ModelReyvor;
import divinerpg.client.models.boss.ModelSoulFiend;
import divinerpg.client.models.boss.ModelSunstorm;
import divinerpg.client.models.boss.ModelTermasect;
import divinerpg.client.models.boss.ModelTwilightDemon;
import divinerpg.client.models.boss.ModelVamacheron;
import divinerpg.client.models.vanilla.ModelWatcher;
import divinerpg.enums.BlockColor;
import divinerpg.registries.BlockRegistry;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RenderStatue
implements BlockEntityRenderer<StatueBlockEntity> {
    private final BlockEntityRendererProvider.Context context;
    public static final ResourceLocation ancient_entity = new ResourceLocation("divinerpg", "textures/entity/ancient_entity.png");
    public static final ResourceLocation densos = new ResourceLocation("divinerpg", "textures/entity/densos.png");
    public static final ResourceLocation dramix = new ResourceLocation("divinerpg", "textures/entity/dramix.png");
    public static final ResourceLocation eternal_archer = new ResourceLocation("divinerpg", "textures/entity/eternal_archer.png");
    public static final ResourceLocation karot = new ResourceLocation("divinerpg", "textures/entity/karot.png");
    public static final ResourceLocation king_of_scorchers = new ResourceLocation("divinerpg", "textures/entity/king_of_scorchers.png");
    public static final ResourceLocation parasecta = new ResourceLocation("divinerpg", "textures/entity/parasecta.png");
    public static final ResourceLocation reyvor = new ResourceLocation("divinerpg", "textures/entity/reyvor.png");
    public static final ResourceLocation soul_fiend = new ResourceLocation("divinerpg", "textures/entity/soul_fiend.png");
    public static final ResourceLocation the_watcher = new ResourceLocation("divinerpg", "textures/entity/the_watcher_warped.png");
    public static final ResourceLocation twilight_demon = new ResourceLocation("divinerpg", "textures/entity/twilight_demon.png");
    public static final ResourceLocation vamacheron = new ResourceLocation("divinerpg", "textures/entity/mortum_cadillion.png");
    public static final ResourceLocation ayeraco_blue = new ResourceLocation("divinerpg", "textures/entity/ayeraco_blue.png");
    public static final ResourceLocation ayeraco_green = new ResourceLocation("divinerpg", "textures/entity/ayeraco_green.png");
    public static final ResourceLocation ayeraco_pink = new ResourceLocation("divinerpg", "textures/entity/ayeraco_pink.png");
    public static final ResourceLocation ayeraco_purple = new ResourceLocation("divinerpg", "textures/entity/ayeraco_purple.png");
    public static final ResourceLocation ayeraco_red = new ResourceLocation("divinerpg", "textures/entity/ayeraco_red.png");
    public static final ResourceLocation ayeraco_yellow = new ResourceLocation("divinerpg", "textures/entity/ayeraco_yellow.png");
    public static final ResourceLocation ayeraco_white = new ResourceLocation("divinerpg", "textures/entity/ayeraco_white.png");
    public static final ResourceLocation termasect = new ResourceLocation("divinerpg", "textures/entity/termasect.png");
    public static final ResourceLocation sunstorm = new ResourceLocation("divinerpg", "textures/entity/sunstorm.png");
    public static final ResourceLocation experienced_cori = new ResourceLocation("divinerpg", "textures/entity/experienced_cori.png");
    public static final ResourceLocation kitra = new ResourceLocation("divinerpg", "textures/entity/kitra.png");

    public RenderStatue(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(StatueBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Model model = this.getModel(te);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)te.m_58900_().m_61143_((Property)AbstractFurnaceBlock.f_48683_)).m_122435_()));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        Block block = te.m_58900_().m_60734_();
        if (block == BlockRegistry.kitraStatue.get()) {
            matrixStack.m_85841_(0.25f, 0.25f, 0.25f);
            matrixStack.m_252880_(0.0f, 5.0f, 0.0f);
        } else if (block == BlockRegistry.ancientEntityStatue.get()) {
            matrixStack.m_85841_(0.45f, 0.45f, 0.45f);
            matrixStack.m_252880_(0.0f, 1.8f, 0.0f);
        } else if (block == BlockRegistry.theWatcherStatue.get()) {
            matrixStack.m_85841_(0.25f, 0.25f, 0.25f);
            matrixStack.m_252880_(0.0f, 4.5f, 0.0f);
        }
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)this.texture(te)));
        model.m_7695_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(@NotNull StatueBlockEntity tile) {
        return true;
    }

    private Model getModel(StatueBlockEntity tile) {
        Block block = tile.m_58900_().m_60734_();
        if (block == BlockRegistry.ancientEntityStatue.get()) {
            return new ModelAncientEntity(this.context.m_173582_(ModelAncientEntity.LAYER_LOCATION));
        }
        if (block == BlockRegistry.densosStatue.get()) {
            return new ModelDensos(this.context.m_173582_(ModelDensos.LAYER_LOCATION));
        }
        if (block == BlockRegistry.dramixStatue.get()) {
            return new ModelDramix(this.context.m_173582_(ModelDramix.LAYER_LOCATION));
        }
        if (block == BlockRegistry.eternalArcherStatue.get()) {
            return new ModelEternalArcher(this.context.m_173582_(ModelEternalArcher.LAYER_LOCATION));
        }
        if (block == BlockRegistry.karotStatue.get()) {
            return new ModelKarot(this.context.m_173582_(ModelKarot.LAYER_LOCATION));
        }
        if (block == BlockRegistry.kingOfScorchersStatue.get()) {
            return new ModelKingOfScorchers(this.context.m_173582_(ModelKingOfScorchers.LAYER_LOCATION));
        }
        if (block == BlockRegistry.parasectaStatue.get()) {
            return new ModelParasecta(this.context.m_173582_(ModelParasecta.LAYER_LOCATION));
        }
        if (block == BlockRegistry.reyvorStatue.get()) {
            return new ModelDensos(this.context.m_173582_(ModelReyvor.LAYER_LOCATION));
        }
        if (block == BlockRegistry.soulFiendStatue.get()) {
            return new ModelSoulFiend(this.context.m_173582_(ModelSoulFiend.LAYER_LOCATION));
        }
        if (block == BlockRegistry.theWatcherStatue.get()) {
            return new ModelWatcher(this.context.m_173582_(ModelWatcher.LAYER_LOCATION));
        }
        if (block == BlockRegistry.twilightDemonStatue.get()) {
            return new ModelTwilightDemon(this.context.m_173582_(ModelTwilightDemon.LAYER_LOCATION));
        }
        if (block == BlockRegistry.vamacheronStatue.get()) {
            return new ModelVamacheron(this.context.m_173582_(ModelVamacheron.LAYER_LOCATION));
        }
        if (block == BlockRegistry.ayeracoStatue.get()) {
            return new ModelAyeraco(this.context.m_173582_(ModelAyeraco.LAYER_LOCATION));
        }
        if (block == BlockRegistry.termasectStatue.get()) {
            return new ModelTermasect(this.context.m_173582_(ModelTermasect.LAYER_LOCATION));
        }
        if (block == BlockRegistry.sunstormStatue.get()) {
            return new ModelSunstorm(this.context.m_173582_(ModelSunstorm.LAYER_LOCATION));
        }
        if (block == BlockRegistry.experiencedCoriStatue.get()) {
            return new ModelExperiencedCori(this.context.m_173582_(ModelExperiencedCori.LAYER_LOCATION));
        }
        if (block == BlockRegistry.kitraStatue.get()) {
            return new ModelKitra(this.context.m_173582_(ModelKitra.LAYER_LOCATION));
        }
        return new BookModel(this.context.m_173582_(ModelLayers.f_171271_));
    }

    private ResourceLocation texture(StatueBlockEntity tile) {
        Block block = tile.m_58900_().m_60734_();
        if (block == BlockRegistry.ancientEntityStatue.get()) {
            return ancient_entity;
        }
        if (block == BlockRegistry.densosStatue.get()) {
            return densos;
        }
        if (block == BlockRegistry.dramixStatue.get()) {
            return dramix;
        }
        if (block == BlockRegistry.eternalArcherStatue.get()) {
            return eternal_archer;
        }
        if (block == BlockRegistry.karotStatue.get()) {
            return karot;
        }
        if (block == BlockRegistry.kingOfScorchersStatue.get()) {
            return king_of_scorchers;
        }
        if (block == BlockRegistry.parasectaStatue.get()) {
            return parasecta;
        }
        if (block == BlockRegistry.reyvorStatue.get()) {
            return reyvor;
        }
        if (block == BlockRegistry.soulFiendStatue.get()) {
            return soul_fiend;
        }
        if (block == BlockRegistry.theWatcherStatue.get()) {
            return the_watcher;
        }
        if (block == BlockRegistry.twilightDemonStatue.get()) {
            return twilight_demon;
        }
        if (block == BlockRegistry.vamacheronStatue.get()) {
            return vamacheron;
        }
        if (block == BlockRegistry.ayeracoStatue.get()) {
            return switch ((BlockColor)((Object)tile.m_58900_().m_61143_(BlockStatue.COLOR))) {
                case BlockColor.BLUE -> ayeraco_blue;
                case BlockColor.GREEN -> ayeraco_green;
                case BlockColor.PINK -> ayeraco_pink;
                case BlockColor.PURPLE -> ayeraco_purple;
                case BlockColor.RED -> ayeraco_red;
                case BlockColor.YELLOW -> ayeraco_yellow;
                default -> ayeraco_white;
            };
        }
        if (block == BlockRegistry.termasectStatue.get()) {
            return termasect;
        }
        if (block == BlockRegistry.sunstormStatue.get()) {
            return sunstorm;
        }
        if (block == BlockRegistry.experiencedCoriStatue.get()) {
            return experienced_cori;
        }
        if (block == BlockRegistry.kitraStatue.get()) {
            return kitra;
        }
        return new ResourceLocation("minecraft:textures/block/stone.png");
    }
}

