/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jade;

import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import divinerpg.DivineRPG;
import divinerpg.compat.jade.ModPlugin;
import divinerpg.util.PortalAccessManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public enum PortalProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        Player player = accessor.getPlayer();
        IElementHelper helper = tooltip.getElementHelper();
        if (!Screen.m_96638_()) {
            tooltip.add(1, helper.text((Component)Component.m_237113_((String)"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 SHIFT \u0434\u043b\u044f \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430 \u043a\u0432\u0435\u0441\u0442\u043e\u0432")));
            return;
        }
        ResourceKey<Level> dimensionKey = PortalAccessManager.getDimensionForBlock(block);
        if (dimensionKey == null) {
            return;
        }
        List<String> questHexIds = PortalAccessManager.DIMENSION_QUEST_REQUIREMENTS.get(dimensionKey);
        if (questHexIds == null || questHexIds.isEmpty()) {
            return;
        }
        BaseQuestFile file = FTBQuestsAPI.api().getQuestFile(true);
        if (file == null) {
            return;
        }
        TeamData teamData = file.getNullableTeamData(player.m_20148_());
        if (teamData == null) {
            return;
        }
        for (int i = questHexIds.size() - 1; i >= 0; --i) {
            String hexId = questHexIds.get(i);
            try {
                long questId = Long.parseUnsignedLong(hexId, 16);
                QuestObject quest = file.get(questId);
                if (quest == null) continue;
                boolean done = teamData.isCompleted(quest);
                MutableComponent text = Component.m_237113_((String)(done ? "\u2714 " : "\u2718 ")).m_7220_(quest.getTitle());
                text.m_130940_(done ? ChatFormatting.GREEN : ChatFormatting.RED);
                tooltip.add(1, helper.text((Component)text));
                continue;
            }
            catch (NumberFormatException e) {
                DivineRPG.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public ResourceLocation getUid() {
        return ModPlugin.PORTAL;
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
    }
}

