/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.ai;

import divinerpg.enums.ILaunchFireBall;
import divinerpg.enums.ILaunchThrowable;
import java.util.function.BiFunction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class AIDivineFireballAttack
extends Goal {
    private final Mob parentEntity;
    private final BiFunction<Mob, Entity, Entity> createFireballFunc;
    public int attackTimer;
    private final int attackDelay;
    private final int maxDistance;
    private final SoundEvent beforeShoot;
    private final SoundEvent onShoot;

    public AIDivineFireballAttack(Mob parentEntity, BiFunction<Mob, Entity, Entity> createFireballFunc, int attackDelay, int maxDistance, SoundEvent beforeShoot, SoundEvent onShoot) {
        this.parentEntity = parentEntity;
        this.createFireballFunc = createFireballFunc;
        this.attackDelay = attackDelay;
        this.maxDistance = maxDistance;
        this.beforeShoot = beforeShoot;
        this.onShoot = onShoot;
    }

    public AIDivineFireballAttack(Mob ghast, ILaunchFireBall func) {
        this(ghast, func::createFireball, 20, 64, SoundEvents.f_11924_, SoundEvents.f_11923_);
    }

    public AIDivineFireballAttack(Mob ghast, ILaunchFireBall createFireball, SoundEvent onShoot) {
        this(ghast, createFireball::createFireball, 20, 64, null, onShoot);
    }

    public AIDivineFireballAttack(Mob ghast, ILaunchThrowable createThrowable, SoundEvent onShoot) {
        this(ghast, createThrowable::createFireball, 20, 64, null, onShoot);
    }

    public boolean m_8045_() {
        return super.m_8045_();
    }

    public void m_8056_() {
        this.attackTimer = 0;
    }

    public void m_8041_() {
    }

    public void m_8037_() {
        LivingEntity entitylivingbase;
        if (this.parentEntity != null && (entitylivingbase = this.parentEntity.m_5448_()) != null) {
            if (Math.sqrt(entitylivingbase.m_20270_((Entity)this.parentEntity)) < (double)this.maxDistance && this.parentEntity.m_142582_((Entity)entitylivingbase)) {
                Level world = this.parentEntity.m_9236_();
                ++this.attackTimer;
                if (this.attackTimer == this.attackDelay - 10) {
                    this.playSound(this.beforeShoot);
                }
                if (this.attackTimer == this.attackDelay) {
                    this.playSound(this.onShoot);
                    world.m_7967_(this.createFireballFunc.apply(this.parentEntity, (Entity)entitylivingbase));
                    this.attackTimer = this.attackDelay * -2;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            if (this.attackTimer <= 10) {
                // empty if block
            }
        }
    }

    public boolean m_8036_() {
        return this.parentEntity.m_21188_() != null;
    }

    private void playSound(SoundEvent event) {
        if (this.parentEntity == null || this.parentEntity.m_9236_() == null || event == null) {
            return;
        }
        RandomSource rand = this.parentEntity.m_9236_().m_213780_();
        this.parentEntity.m_9236_().m_5594_(null, this.parentEntity.m_20183_(), event, SoundSource.HOSTILE, 10.0f, (rand.m_188501_() - rand.m_188501_()) * 0.2f + 1.0f);
    }
}

