/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.ai;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class FollowLeaderGoal
extends Goal {
    protected final Mob mob;
    protected final Class<? extends Mob> leader;
    protected final double speedModifier;
    protected final float stopDistance;
    protected final float areaSize;
    protected final Predicate<LivingEntity> followPredicate;
    protected final PathNavigation navigation;
    protected final TargetingConditions conditions;
    @Nullable
    protected Mob following;
    protected int timetorecalcpath;
    protected float oldWaterCost;

    public FollowLeaderGoal(Mob mob, Class<? extends Mob> leader, double speedModifier, float stopDistance, float areaSize) {
        this.mob = mob;
        this.leader = leader;
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
        this.areaSize = areaSize;
        this.followPredicate = entity -> entity != null && entity.getClass() == leader;
        this.navigation = mob.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.conditions = TargetingConditions.m_148353_().m_26883_((double)areaSize).m_26888_(this.followPredicate);
    }

    public boolean m_8036_() {
        this.following = (Mob)this.mob.m_9236_().m_45963_(this.leader, this.conditions, (LivingEntity)this.mob, (double)this.stopDistance, this.speedModifier, (double)this.areaSize, this.mob.m_20191_().m_82400_((double)this.areaSize));
        return this.following != null;
    }

    public boolean m_8045_() {
        return this.following != null && !this.navigation.m_26571_() && this.mob.m_20280_((Entity)this.following) > (double)(this.stopDistance * this.stopDistance);
    }

    public void m_8056_() {
        this.timetorecalcpath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.following = null;
        this.navigation.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        if (this.following != null && !this.mob.m_21523_()) {
            this.mob.m_21563_().m_24960_((Entity)this.following, 10.0f, (float)this.mob.m_8132_());
            if (--this.timetorecalcpath <= 0) {
                double dz;
                double dy;
                this.timetorecalcpath = this.m_183277_(10);
                double dx = this.mob.m_20185_() - this.following.m_20185_();
                double dsquared = dx * dx + (dy = this.mob.m_20186_() - this.following.m_20186_()) * dy + (dz = this.mob.m_20189_() - this.following.m_20189_()) * dz;
                if (dsquared > (double)(this.stopDistance * this.stopDistance)) {
                    this.navigation.m_5624_((Entity)this.following, this.speedModifier);
                } else {
                    this.navigation.m_26573_();
                    LookControl lookcontrol = this.following.m_21563_();
                    if (dsquared <= (double)this.stopDistance || lookcontrol.m_24969_() == this.mob.m_20185_() && lookcontrol.m_24970_() == this.mob.m_20186_() && lookcontrol.m_24971_() == this.mob.m_20189_()) {
                        this.navigation.m_26519_(this.mob.m_20185_() + dx, this.mob.m_20186_(), this.mob.m_20189_() + dz, this.speedModifier);
                    }
                }
            }
        }
    }
}

