/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.ai;

import java.util.EnumSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class MoveTowardsGoal
extends Goal {
    private final Mob mob;
    private double wantedX;
    private double wantedY;
    private double wantedZ;
    private final double speedModifier;

    public MoveTowardsGoal(Mob p_25633_, double p_25634_) {
        this.mob = p_25633_;
        this.speedModifier = p_25634_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.mob.m_21533_()) {
            return false;
        }
        Vec3 vec3 = MoveTowardsGoal.getPosTowards(this.mob, 16, 7, Vec3.m_82539_((Vec3i)this.mob.m_21534_()), 1.5707963705062866);
        if (vec3 == null) {
            return false;
        }
        this.wantedX = vec3.f_82479_;
        this.wantedY = vec3.f_82480_;
        this.wantedZ = vec3.f_82481_;
        return true;
    }

    @Nullable
    public static Vec3 generateRandomPos(Mob p_148543_, Supplier<BlockPos> p_148544_) {
        return MoveTowardsGoal.generateRandomPos(p_148543_, p_148544_);
    }

    @Nullable
    public static Vec3 getPosTowards(Mob p_148413_, int p_148414_, int p_148415_, Vec3 p_148416_, double p_148417_) {
        Vec3 vec3 = p_148416_.m_82492_(p_148413_.m_20185_(), p_148413_.m_20186_(), p_148413_.m_20189_());
        boolean flag = MoveTowardsGoal.mobRestricted(p_148413_, p_148414_);
        return MoveTowardsGoal.generateRandomPos(p_148413_, () -> {
            BlockPos blockpos = RandomPos.m_217855_((RandomSource)p_148413_.m_217043_(), (int)p_148414_, (int)p_148415_, (int)0, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)p_148417_);
            return blockpos == null ? null : MoveTowardsGoal.generateRandomPosTowardDirection(p_148413_, p_148414_, flag, blockpos);
        });
    }

    @Nullable
    private static BlockPos generateRandomPosTowardDirection(Mob p_148437_, int p_148438_, boolean p_148439_, BlockPos p_148440_) {
        BlockPos blockpos = MoveTowardsGoal.generateRandomPosTowardDirection(p_148437_, p_148438_, p_148437_.m_217043_(), p_148440_);
        return !MoveTowardsGoal.isOutsideLimits(blockpos, p_148437_) && !MoveTowardsGoal.isRestricted(p_148439_, p_148437_, blockpos) && !GoalUtils.m_148448_((PathNavigation)p_148437_.m_21573_(), (BlockPos)blockpos) && !MoveTowardsGoal.hasMalus(p_148437_, blockpos) ? blockpos : null;
    }

    public static boolean isOutsideLimits(BlockPos p_148452_, Mob p_148453_) {
        return p_148452_.m_123342_() < p_148453_.m_9236_().m_141937_() || p_148452_.m_123342_() > p_148453_.m_9236_().m_151558_();
    }

    public static boolean isRestricted(boolean p_148455_, Mob p_148456_, BlockPos p_148457_) {
        return p_148455_ && !p_148456_.m_21444_(p_148457_);
    }

    public static boolean hasMalus(Mob p_148459_, BlockPos p_148460_) {
        return p_148459_.m_21439_(WalkNodeEvaluator.m_77604_((BlockGetter)p_148459_.m_9236_(), (BlockPos.MutableBlockPos)p_148460_.m_122032_())) != 0.0f;
    }

    public static BlockPos generateRandomPosTowardDirection(Mob p_217864_, int p_217865_, RandomSource p_217866_, BlockPos p_217867_) {
        int i = p_217867_.m_123341_();
        int j = p_217867_.m_123343_();
        if (p_217864_.m_21536_() && p_217865_ > 1) {
            BlockPos blockpos = p_217864_.m_21534_();
            i = p_217864_.m_20185_() > (double)blockpos.m_123341_() ? (i -= p_217866_.m_188503_(p_217865_ / 2)) : (i += p_217866_.m_188503_(p_217865_ / 2));
            j = p_217864_.m_20189_() > (double)blockpos.m_123343_() ? (j -= p_217866_.m_188503_(p_217865_ / 2)) : (j += p_217866_.m_188503_(p_217865_ / 2));
        }
        return new BlockPos((int)((double)i + p_217864_.m_20185_()), (int)((double)p_217867_.m_123342_() + p_217864_.m_20186_()), (int)((double)j + p_217864_.m_20189_()));
    }

    public static boolean mobRestricted(Mob p_148443_, int p_148444_) {
        return p_148443_.m_21536_() && p_148443_.m_21534_().m_203195_((Position)p_148443_.m_20182_(), (double)(p_148443_.m_21535_() + (float)p_148444_) + 1.0);
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }
}

