/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.registries.SoundRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public abstract class EntityDivineMerchant
extends Villager {
    public abstract String[] getChatMessages();

    public EntityDivineMerchant(EntityType<? extends Villager> type, Level level) {
        super(type, level);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(false);
    }

    @NotNull
    protected Component m_5677_() {
        return this.m_6095_().m_20676_();
    }

    protected void m_8058_(MerchantOffer offer) {
        int xp = 3 + this.f_19796_.m_188503_(4);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 1500, 4));
        if (offer.m_45383_()) {
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), xp));
        }
    }

    public boolean m_7296_(int i) {
        return i > 2;
    }

    public int m_5792_() {
        return 2;
    }

    public EntityDivineMerchant getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob mate) {
        return null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected SoundEvent m_7515_() {
        return switch (this.f_19796_.m_188503_(3)) {
            case 0 -> (SoundEvent)SoundRegistry.MERCHANT_3.get();
            case 2 -> (SoundEvent)SoundRegistry.MERCHANT_2.get();
            default -> (SoundEvent)SoundRegistry.MERCHANT_1.get();
        };
    }

    public int m_8100_() {
        return 160;
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)SoundRegistry.MERCHANT_HURT.get();
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.MERCHANT_HURT.get();
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.m_9236_().m_5776_()) {
            MerchantOffers offers = this.m_6616_();
            offers.clear();
            this.m_7604_();
            if (!offers.isEmpty()) {
                if (this.m_9236_().m_45914_(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, 16.0) && this.m_35520_()) {
                    this.m_35510_();
                }
                this.m_35540_(player);
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
                player.m_5661_((Component)Component.m_237115_((String)this.getChatMessages()[player.m_217043_().m_188503_(this.getChatMessages().length)]), true);
                return InteractionResult.CONSUME;
            }
        }
        this.m_35518_();
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    protected void m_7604_() {
        MerchantOffers offers = this.m_6616_();
        VillagerProfession profession = this.m_7141_().m_35571_();
        Int2ObjectMap tradeMap = (Int2ObjectMap)VillagerTrades.f_35627_.get(profession);
        if (tradeMap != null) {
            for (int level = 1; level <= 5; ++level) {
                VillagerTrades.ItemListing[] levelTrades = (VillagerTrades.ItemListing[])tradeMap.get(level);
                if (levelTrades == null) continue;
                this.m_35277_(offers, levelTrades, levelTrades.length);
            }
        }
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_6785_(double distance) {
        return this.m_7809_() > 0;
    }

    public void m_35510_() {
        for (MerchantOffer offer : this.m_6616_()) {
            offer.m_45369_();
            offer.m_45372_();
        }
    }

    private boolean m_35520_() {
        for (MerchantOffer offer : this.m_6616_()) {
            if (!offer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    protected void m_35540_(Player player) {
        if (player != this.f_20888_) {
            for (MerchantOffer offer : this.m_6616_()) {
                offer.m_45353_(-Mth.m_14143_((float)offer.m_45378_()));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_35303_() > 0) {
            this.m_35319_(this.m_35303_() - 1);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        this.m_9236_().m_7605_((Entity)this, (byte)13);
        this.m_35518_();
        return super.m_6469_(source, amount);
    }

    public void m_7822_(byte type) {
        if (type == 12) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123750_);
        } else if (type == 13) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123792_);
        } else if (type == 14) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123748_);
        } else if (type == 42) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123769_);
        } else {
            super.m_7822_(type);
        }
    }

    public void m_7189_(@Nullable Player player) {
        boolean flag = this.m_7962_() != null && player == null;
        super.m_7189_(player);
        if (flag) {
            this.m_7996_();
        }
    }

    private void m_35518_() {
        this.m_35319_(40);
        if (!this.m_9236_().m_5776_()) {
            this.m_216990_((SoundEvent)SoundRegistry.MERCHANT_HURT.get());
        }
    }

    protected void m_7996_() {
        super.m_7996_();
        this.m_35519_();
    }

    private void m_35519_() {
        for (MerchantOffer offer : this.m_6616_()) {
            offer.m_45376_();
        }
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions size) {
        return 1.62f;
    }

    public boolean m_5545_(LevelAccessor level, @NotNull MobSpawnType type) {
        return !level.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_MUSHROOM) && !level.m_204166_(this.m_20183_()).m_203565_(Biomes.f_220594_);
    }

    public static class DivineTrades
    implements VillagerTrades.ItemListing {
        private final ItemStack input1;
        private final ItemStack input2;
        private final ItemStack output;
        private final int xp;
        private final int stock;

        public DivineTrades(ItemStack input1, ItemStack input2, ItemStack output, int stock, int xp) {
            this.input1 = input1;
            this.input2 = input2;
            this.output = output;
            this.stock = stock + 1;
            this.xp = xp;
        }

        public DivineTrades(ItemStack input1, ItemStack output, int stock, int xp) {
            this(input1, ItemStack.f_41583_, output, stock, xp);
        }

        public MerchantOffer m_213663_(@NotNull Entity entity, @NotNull RandomSource rand) {
            return new MerchantOffer(this.input1, this.input2, this.output, this.stock, this.xp, 0.0f);
        }
    }
}

