/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.entities.base.EntityDivineMonster;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class EntityPeacefulUntilAttacked
extends EntityDivineMonster {
    protected int angerLevel;
    protected UUID angerTargetUUID;

    public EntityPeacefulUntilAttacked(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Anger", this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.m_128359_("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.m_128359_("HurtBy", "");
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.angerLevel = compound.m_128451_("Anger");
        String s = compound.m_128461_("HurtBy");
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            this.m_6710_((LivingEntity)this.m_9236_().m_46003_(this.angerTargetUUID));
        }
    }

    public void m_6710_(@Nullable LivingEntity livingBase) {
        super.m_6710_(livingBase);
        if (livingBase != null && livingBase instanceof Player) {
            this.angerTargetUUID = livingBase.m_20148_();
            this.alertOthers();
        }
    }

    protected void alert(@Nullable LivingEntity livingBase) {
        super.m_6710_(livingBase);
        if (livingBase != null && livingBase instanceof Player) {
            this.angerTargetUUID = livingBase.m_20148_();
        }
    }

    protected void alertOthers() {
        double d0 = this.m_21133_(Attributes.f_22277_);
        AABB aabb = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(d0, 10.0, d0);
        this.m_9236_().m_6443_(((Object)((Object)this)).getClass(), aabb, EntitySelector.f_20408_).stream().filter(entity -> entity != this && entity != null && this.m_5448_() != null && entity.m_5448_() == null && !entity.m_7307_((Entity)this.m_5448_())).forEach(entity -> entity.alert(this.m_5448_()));
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source != null) {
            this.angerLevel = 400 + this.f_19796_.m_188503_(400);
        }
        return super.m_6469_(source, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        --this.angerLevel;
        if (!this.m_5912_() && this.m_5448_() != null) {
            this.m_6710_(null);
        }
    }

    public boolean m_5912_() {
        return this.angerLevel > 0;
    }
}

