/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.registries.EntityRegistry;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public interface FactionEntity {
    public Faction getFaction();

    default public boolean modifyReputationOnHurt(DamageSource source, float f) {
        Entity entity;
        if (source.m_7640_() != null && (entity = source.m_7640_()) instanceof Player) {
            Player player = (Player)entity;
            this.getFaction().modifyReputation(player, -1);
            return true;
        }
        if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            this.getFaction().modifyReputation(player, -1);
            return true;
        }
        return false;
    }

    default public void modifyReputationOnDeath(DamageSource source) {
        block3: {
            Object object;
            block2: {
                if (source.m_7640_() == null || !((object = source.m_7640_()) instanceof Player)) break block2;
                Player player = (Player)object;
                this.getFaction().modifyReputation(player, -10);
                for (Faction opposer : this.getFaction().enemies) {
                    opposer.modifyReputation(player, 2);
                }
                break block3;
            }
            if (source.m_7639_() == null || !((object = source.m_7639_()) instanceof Player)) break block3;
            Player player = (Player)object;
            this.getFaction().modifyReputation(player, -10);
            for (Faction opposer : this.getFaction().enemies) {
                opposer.modifyReputation(player, 2);
            }
        }
    }

    public static class Faction {
        public static final Faction GROGLIN = new Faction(true, 0, "groglin_reputation"){

            @Override
            public boolean isAgressiveTowards(LivingEntity entity) {
                return entity.m_21023_((MobEffect)MobEffectRegistry.GROGLIN_BOUNTY.get()) || super.isAgressiveTowards(entity);
            }
        };
        public static final Faction GRUZZORLUG = new Faction(true, 0, "gruzzorlug_reputation"){

            @Override
            public boolean isAgressiveTowards(LivingEntity entity) {
                return entity.m_21023_((MobEffect)MobEffectRegistry.GRUZZORLUG_TARGET.get()) || super.isAgressiveTowards(entity);
            }
        };
        public static final Faction ICEIKA_MERCHANT = new Faction(false, 20, "iceika_merchant_reputation").addEnemy(GROGLIN).addEnemy(GRUZZORLUG);
        public final ArrayList<Faction> enemies = new ArrayList();
        public final ArrayList<Faction> allies = new ArrayList();
        public final ArrayList<EntityType<?>> nonFactionEnemies;
        public final ArrayList<EntityType<?>> nonFactionAllies = new ArrayList();
        public final String reputationIdentifier;
        public final boolean isAutoAggressive;
        public final int startingReputation;

        public static LivingEntity getNearestEnemy(LivingEntity from, AABB searchArea, TargetingConditions conditions) {
            List enemies = from.m_9236_().m_6249_((Entity)from, searchArea, entity -> {
                if (entity instanceof LivingEntity) {
                    LivingEntity ent = (LivingEntity)entity;
                    if (from instanceof FactionEntity) {
                        FactionEntity fac = (FactionEntity)from;
                        if (fac.getFaction().isAgressiveTowards(ent)) return true;
                    }
                }
                if (!(entity instanceof FactionEntity)) return false;
                FactionEntity fact = (FactionEntity)entity;
                if (!fact.getFaction().isAgressiveTowards(from)) return false;
                return true;
            });
            double closest = -1.0;
            LivingEntity nearestEnemy = null;
            for (Entity enemy : enemies) {
                if (!conditions.m_26885_(from, (LivingEntity)enemy)) continue;
                double distance = enemy.m_20280_((Entity)from);
                if (closest != -1.0 && !(distance < closest)) continue;
                closest = distance;
                nearestEnemy = (LivingEntity)enemy;
            }
            return nearestEnemy;
        }

        public static boolean hasNearbyTarget(@Nullable Entity from, AABB searchArea, Faction faction) {
            return !from.m_9236_().m_6249_(from, searchArea, entity -> {
                Player player;
                LivingEntity ent;
                return entity instanceof LivingEntity && faction.isAgressiveTowards(ent = (LivingEntity)entity) && (!(entity instanceof Player) || !(player = (Player)entity).m_5833_());
            }).isEmpty();
        }

        public Faction(boolean isAutoAgressive, int startingReputation, String reputationIdentifier) {
            this.isAutoAggressive = isAutoAgressive;
            this.startingReputation = startingReputation;
            this.reputationIdentifier = reputationIdentifier;
            this.nonFactionEnemies = isAutoAgressive ? null : new ArrayList();
        }

        public Faction addEnemy(Faction faction) {
            this.enemies.add(faction);
            this.allies.remove(faction);
            return this;
        }

        public Faction addEnemy(LivingEntity entity) {
            if (!this.isAutoAggressive) {
                this.nonFactionEnemies.add(entity.m_6095_());
            }
            this.nonFactionAllies.remove(entity.m_6095_());
            return this;
        }

        public Faction addAlly(Faction faction) {
            this.allies.add(faction);
            this.enemies.remove(faction);
            return this;
        }

        public Faction addAlly(LivingEntity entity) {
            EntityType t = entity.m_6095_();
            this.nonFactionAllies.add(t);
            if (!this.isAutoAggressive) {
                this.nonFactionEnemies.remove(t);
            }
            return this;
        }

        public boolean isAlly(LivingEntity entity) {
            FactionEntity e;
            EntityType type = entity.m_6095_();
            return entity instanceof FactionEntity && ((e = (FactionEntity)entity).getFaction().equals(this) || this.allies.contains(e.getFaction())) || this.nonFactionAllies.contains(type);
        }

        public boolean isAgressiveTowards(Faction faction) {
            return faction != this && !this.allies.contains(faction) && (this.isAutoAggressive || this.enemies.contains(faction));
        }

        public boolean isAgressiveTowards(LivingEntity entity) {
            Player player;
            EntityType type = entity.m_6095_();
            if (this.nonFactionAllies.contains(type)) {
                return false;
            }
            if (!this.isAutoAggressive && this.nonFactionEnemies.contains(type)) {
                return true;
            }
            if (entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_() && this.getReputation(player) < (this.isAutoAggressive ? 50 : -10)) {
                return true;
            }
            if (entity instanceof FactionEntity) {
                FactionEntity fac = (FactionEntity)entity;
                return this.isAgressiveTowards(fac.getFaction());
            }
            return this.isAutoAggressive;
        }

        public void modifyReputation(Player player, int amount) {
            CompoundTag playerData = Utils.getPlayerData(player);
            playerData.m_128405_(this.reputationIdentifier, this.getReputation(player) + amount);
            Utils.setPlayerData(player, playerData);
        }

        public int getReputation(Player player) {
            CompoundTag playerData = Utils.getPlayerData(player);
            return playerData != null && playerData.m_128441_(this.reputationIdentifier) ? playerData.m_128451_(this.reputationIdentifier) : this.startingReputation;
        }

        static {
            ArrayList<EntityType> iceikaNature = new ArrayList<EntityType>();
            iceikaNature.add(EntityType.f_20556_);
            iceikaNature.add(EntityType.f_20519_);
            iceikaNature.add(EntityType.f_20489_);
            iceikaNature.add(EntityType.f_20514_);
            iceikaNature.add((EntityType)EntityRegistry.WHALE.get());
            iceikaNature.add((EntityType)EntityRegistry.LIOPLEURODON.get());
            iceikaNature.add((EntityType)EntityRegistry.AEQUOREA.get());
            iceikaNature.add((EntityType)EntityRegistry.ROBBIN.get());
            iceikaNature.add((EntityType)EntityRegistry.WOLPERTINGER.get());
            iceikaNature.add((EntityType)EntityRegistry.PALE_ARCHER.get());
            iceikaNature.add((EntityType)EntityRegistry.FROZEN_FLESH.get());
            iceikaNature.add((EntityType)EntityRegistry.ROLLUM.get());
            iceikaNature.add((EntityType)EntityRegistry.ALICANTO.get());
            iceikaNature.add((EntityType)EntityRegistry.SENG.get());
            iceikaNature.add((EntityType)EntityRegistry.HASTREUS.get());
            iceikaNature.add((EntityType)EntityRegistry.GLACIDE.get());
            iceikaNature.add((EntityType)EntityRegistry.FRACTITE.get());
            Faction.GRUZZORLUG.nonFactionAllies.addAll(iceikaNature);
            GRUZZORLUG.addEnemy(GROGLIN).addEnemy(ICEIKA_MERCHANT);
            iceikaNature.remove(EntityRegistry.SENG.get());
            iceikaNature.remove(EntityType.f_20556_);
            iceikaNature.add((EntityType)EntityRegistry.SABEAR.get());
            Faction.GROGLIN.nonFactionAllies.addAll(iceikaNature);
            GROGLIN.addEnemy(GRUZZORLUG).addEnemy(ICEIKA_MERCHANT);
        }
    }
}

