/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class JMonsterEntity
extends Monster
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(JMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected JMonsterEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected abstract void controller(AnimatableManager.ControllerRegistrar var1);

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.controller(controllers);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType type) {
        return !level.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_MUSHROOM) && !level.m_204166_(this.m_20183_()).m_203565_(Biomes.f_220594_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("attack", this.isAttacking());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("attack")) {
            this.setAttacking(compound.m_128471_("attack"));
        }
    }

    public boolean isAttacking() {
        return (Boolean)this.m_20088_().m_135370_(ATTACK);
    }

    public void setAttacking(boolean value) {
        this.m_20088_().m_135381_(ATTACK, (Object)value);
    }

    public class AnimatedAttackGoal
    extends MeleeAttackGoal {
        private final JMonsterEntity entity;

        public AnimatedAttackGoal(JMonsterEntity entity, double speed, boolean useLongMemory) {
            super((PathfinderMob)entity, speed, useLongMemory);
            this.entity = entity;
        }

        public void m_8041_() {
            super.m_8041_();
            this.entity.m_21561_(false);
            JMonsterEntity.this.setAttacking(false);
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = JMonsterEntity.this.m_5448_();
            return livingEntity != null && livingEntity.m_6084_();
        }

        protected void m_6739_(@NotNull LivingEntity enemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (pDistToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                JMonsterEntity.this.setAttacking(true);
                this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                this.f_25540_.m_7327_((Entity)enemy);
            }
        }
    }
}

