/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import com.idark.valoria.registries.EffectsRegistry;
import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.EntityLadyLunaSparkler;
import divinerpg.entities.projectile.EntityStar;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.RandomUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityLadyLuna
extends EntityDivineBoss {
    private static final EntityDataAccessor<Byte> JUMPING = SynchedEntityData.m_135353_(EntityLadyLuna.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Integer> PROTECTION = SynchedEntityData.m_135353_(EntityLadyLuna.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final List<BlockPos> acidPositions = new ArrayList<BlockPos>();
    private int protectionTimer;

    public EntityLadyLuna(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.setRandomProtectionValues();
        this.f_21364_ = 500;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 10 == 0 && this.m_20096_()) {
            this.setJumpingData((byte)0);
        }
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 5 == 0) {
            for (int x = (int)this.m_20185_() - 2; x < (int)this.m_20185_() + 2; ++x) {
                for (int y = (int)this.m_20191_().f_82289_; y < (int)this.m_20191_().f_82289_ + 4; ++y) {
                    for (int z = (int)this.m_20189_() - 2; z < (int)this.m_20189_() + 2; ++z) {
                        if (!this.m_9236_().m_8055_(new BlockPos(x, y, z)).m_204336_(BlockTags.f_13035_) && !this.m_9236_().m_8055_(new BlockPos(x, y, z)).m_204336_(BlockTags.f_13106_)) continue;
                        this.m_9236_().m_7731_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_(), 1);
                    }
                }
            }
        }
        BlockPos current = new BlockPos((int)this.m_20185_() - 1, (int)this.m_20186_(), (int)this.m_20189_() - 1);
        BlockPos below = new BlockPos((int)this.m_20185_() - 1, (int)this.m_20186_() - 1, (int)this.m_20189_() - 1);
        BlockState belowState = this.m_9236_().m_8055_(below);
        if (this.m_9236_().m_8055_(current).m_60734_() == Blocks.f_50016_ && belowState.m_60815_() && belowState.m_60779_()) {
            this.m_9236_().m_7731_(current, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "lunic_acid"))).m_49966_(), 1);
            this.acidPositions.add(current);
        }
        if (!this.m_9236_().m_5776_() && this.getProtection() == 0 && this.f_19797_ % 30 == 0) {
            Iterator<BlockPos> iter = this.acidPositions.iterator();
            while (iter.hasNext()) {
                BlockPos pos = iter.next();
                if (this.m_9236_().m_8055_(pos).m_60734_() != ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "lunic_acid"))) {
                    iter.remove();
                    continue;
                }
                if (this.f_19796_.m_188503_(4) != 0) continue;
                EntityLadyLunaSparkler e = new EntityLadyLunaSparkler((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.LADY_LUNA_SPARKLER.get()), this.m_9236_(), (LivingEntity)this);
                e.m_6027_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                this.m_9236_().m_7967_((Entity)e);
            }
        }
        if (this.getProtectionTimer() == 0) {
            this.setRandomProtectionValues();
        } else if (this.getProtectionTimer() > 0) {
            this.setProtectionTimer(this.getProtectionTimer() - 1);
        }
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance instance, @NotNull MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        this.f_19804_.m_135381_(PROTECTION, (Object)this.f_19796_.m_188503_(2));
        return data;
    }

    public int getProtection() {
        return (Integer)this.f_19804_.m_135370_(PROTECTION);
    }

    public void setProtectionType(int i) {
        this.f_19804_.m_135381_(PROTECTION, (Object)i);
        if (i == 0) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.615);
            this.m_21051_(Attributes.f_22281_).m_22100_(44.0);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.45);
            this.m_21051_(Attributes.f_22281_).m_22100_(52.0);
        }
    }

    public void setProtectionTimer(int i) {
        this.protectionTimer = i;
    }

    public int getProtectionTimer() {
        return this.protectionTimer;
    }

    public boolean m_6469_(DamageSource source, float par2) {
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268515_) && this.getProtection() == 0) {
            return false;
        }
        if ((source.m_276093_(DamageTypes.f_268534_) || source.m_19385_().equals("thrown")) && this.getProtection() == 1) {
            return false;
        }
        if (!source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_) && this.getProtection() == 2) {
            return false;
        }
        return super.m_6469_(source, par2);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.LADY_LUNA.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)SoundRegistry.LADY_LUNA_HURT.get();
    }

    public void lungeAtPlayer(Player player) {
        double dx = player.m_20185_() - this.m_20185_();
        double dy = player.m_20186_() - this.m_20186_();
        double dz = player.m_20189_() - this.m_20189_();
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double speed = 1.0;
        this.m_20256_(this.m_20184_().m_82520_((dx /= distance) * speed, (dy /= distance) * speed, (dz /= distance) * speed));
    }

    private void setRandomProtectionValues() {
        this.setProtectionType(this.f_19796_.m_188503_(2));
        this.setProtectionTimer(this.f_19796_.m_216339_(105, 236));
        int attack = this.f_19796_.m_216339_(1, 8);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82377_(17.0, 17.0, 17.0), entity -> entity != null && entity != this && entity.m_6084_());
        if (attack == 1 || attack == 4) {
            this.m_20334_(this.m_20184_().f_82479_, 1.2, this.m_20184_().f_82481_);
            Player p = this.m_9236_().m_45930_((Entity)this, 64.0);
            if (p != null) {
                this.lungeAtPlayer(p);
            }
            this.setJumpingData((byte)1);
            if (RandomUtil.percentChance(0.5)) {
                this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.5f, Level.ExplosionInteraction.NONE);
                this.m_20334_(this.m_20184_().f_82479_, 1.2, this.m_20184_().f_82481_);
            } else {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2));
                this.m_7292_(new MobEffectInstance((MobEffect)EffectsRegistry.ALOEREGEN.get(), 200, 3));
            }
            this.m_9236_().m_5594_(null, this.m_20097_(), SoundEvents.f_11735_, SoundSource.HOSTILE, 2.0f, 0.85f);
        } else if (attack == 2 || attack == 3) {
            for (LivingEntity entity2 : entities) {
                if (this.f_19853_.m_5776_()) continue;
                LightningBolt ent = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                ent.m_6034_(entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_());
                this.m_9236_().m_7967_((Entity)ent);
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 75, 2));
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 105, 2));
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 65, 1));
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 65, 3));
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 85, 3));
                entity2.m_7292_(new MobEffectInstance((MobEffect)EffectsRegistry.EXHAUSTION.get(), 250, 3));
            }
        } else {
            EntityStar star;
            double y;
            double z;
            double x;
            double angle;
            int i;
            for (i = 0; i < 52; ++i) {
                angle = Math.PI * 2 * (double)i / 52.0;
                x = this.m_20185_() + 5.0 * Math.cos(angle);
                z = this.m_20189_() + 5.0 * ((double)this.f_19796_.m_216339_(75, 125) / 100.0) * Math.sin(angle);
                y = this.m_20186_();
                star = new EntityStar((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.STARLIGHT.get()), this.m_20185_() + 0.5, this.m_20186_() + 25.0, this.m_20189_() + 0.5, 45, this.m_9236_());
                star.m_6027_(x, y + 20.0, z);
                star.m_5602_((Entity)this);
                this.m_9236_().m_7967_((Entity)star);
            }
            for (i = 0; i < 75; ++i) {
                angle = Math.PI * 2 * (double)i / 75.0;
                x = this.m_20185_() + 7.0 * Math.cos(angle);
                z = this.m_20189_() + 7.0 * ((double)this.f_19796_.m_216339_(75, 125) / 100.0) * Math.sin(angle);
                y = this.m_20186_();
                star = new EntityStar((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.STARLIGHT.get()), this.m_20185_() + 0.5, this.m_20186_() + 25.0, this.m_20189_() + 0.5, this.m_9236_());
                star.m_6027_(x, y + 25.0, z);
                star.m_5602_((Entity)this);
                this.m_9236_().m_7967_((Entity)star);
            }
            for (i = 0; i < 5; ++i) {
                for (LivingEntity entity3 : entities) {
                    EntityStar star2 = new EntityStar((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.STARLIGHT.get()), this.m_20185_() + 0.5, this.m_20186_() + 25.0, this.m_20189_() + 0.5, this.m_9236_());
                    star2.m_6027_(entity3.m_20185_() + (double)this.f_19796_.m_188501_(), entity3.m_20186_() + 12.0, entity3.m_20189_() + (double)this.f_19796_.m_188501_());
                    star2.m_5602_((Entity)this);
                    this.m_9236_().m_7967_((Entity)star2);
                }
            }
            this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)SoundRegistry.STARLIGHT.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
        }
    }

    public boolean isJumping() {
        return (Byte)this.f_19804_.m_135370_(JUMPING) > 0;
    }

    public void setJumpingData(Byte val) {
        this.f_19804_.m_135381_(JUMPING, (Object)val);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PROTECTION, (Object)0);
        this.f_19804_.m_135372_(JUMPING, (Object)0);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setProtectionType(tag.m_128451_("Immunity"));
        this.setProtectionTimer(tag.m_128451_("ImmunityCooldown"));
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }
}

