/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.block.types.UmbralKeyPadBlock;
import com.idark.valoria.registries.entity.living.minions.UndeadEntity;
import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.boss.CustomPathNavigation;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.scheduling.AoAScheduler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.util.math.ArcRandom;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EntityPossessedVikingArmor
extends EntityDivineBoss
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public boolean isDashing;
    public int dashCooldown;
    public int summonCooldown;
    private final ArcRandom random = new ArcRandom();

    public EntityPossessedVikingArmor(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 1000;
        this.isDashing = false;
        this.dashCooldown = 0;
        this.summonCooldown = 0;
        this.m_274367_(2.3333333f);
    }

    @Override
    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (!this.m_9236_().f_46443_) {
            if (this.f_20919_ == 1) {
                this.triggerAnim("deathController", "death");
            }
            if (this.f_20919_ > 40 && !this.m_213877_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.f_19864_ = false;
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        int radius = 24;
        for (BlockPos searchPos : BlockPos.m_121940_((BlockPos)this.m_20183_().m_7918_(-radius, -radius, -radius), (BlockPos)this.m_20183_().m_7918_(radius, radius, radius))) {
            BlockState blockState = this.m_9236_().m_8055_(searchPos);
            if (blockState.m_60713_((Block)com.idark.valoria.registries.BlockRegistry.umbralKeypad.get())) {
                this.m_9236_().m_7731_(searchPos, (BlockState)blockState.m_61124_((Property)UmbralKeyPadBlock.KEY_CLICKED, (Comparable)Boolean.valueOf(true)), 3);
                continue;
            }
            if (!blockState.m_60713_((Block)BlockRegistry.soulTrap.get())) continue;
            this.m_9236_().m_7731_(searchPos, Blocks.f_50016_.m_49966_(), 3);
            this.m_9236_().m_7731_(searchPos, ((Block)BlockRegistry.soulTrap.get()).m_49966_(), 3);
        }
    }

    private void performLeap() {
        LivingEntity nearestPlayer = this.m_5448_();
        if (nearestPlayer instanceof Player) {
            Vec3 mobPosition = this.m_20182_();
            Vec3 playerPosition = nearestPlayer.m_20182_();
            Vec3 leapVector = playerPosition.m_82546_(mobPosition).m_82541_().m_82490_(1.3);
            this.m_20256_(this.m_20184_().m_82549_(leapVector));
            this.f_19812_ = true;
            this.isDashing = true;
            this.triggerAnim("dashController", "reckless_leap");
            this.dashCooldown = this.random.nextInt(100) + 60;
        }
    }

    private void performSummon() {
        Vec3 lookDirection = this.m_20154_();
        Vec3 eyePosition = this.m_146892_();
        Level level = this.m_9236_();
        this.triggerAnim("swingController", "ice_spikes");
        AoAScheduler.scheduleAsyncTask(() -> {
            for (int i = 1; i <= 4; ++i) {
                Vec3 summonPosition = eyePosition.m_82549_(lookDirection.m_82490_((double)i));
                BlockPos blockPos = new BlockPos((int)summonPosition.f_82479_, (int)summonPosition.f_82480_, (int)summonPosition.f_82481_);
                for (int j = 0; j < 2; ++j) {
                    UndeadEntity undead = (UndeadEntity)((EntityType)EntityTypeRegistry.UNDEAD.get()).m_20615_(level);
                    if (undead == null) continue;
                    undead.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, this.random.nextFloat() * 360.0f, 0.0f);
                    undead.m_21051_(Attributes.f_22276_).m_22100_(65.0);
                    undead.m_21153_(55.0f);
                    undead.m_21051_(Attributes.f_22281_).m_22100_(12.5);
                    level.m_7967_((Entity)undead);
                }
            }
        }, 750, TimeUnit.MILLISECONDS);
        this.summonCooldown = this.random.nextInt(150) + 150;
    }

    @Override
    public void m_8119_() {
        block12: {
            block11: {
                super.m_8119_();
                if (this.m_21223_() >= 9000.0f) {
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.224);
                    this.m_21051_(Attributes.f_22281_).m_22100_(35.0);
                } else if (this.m_21223_() <= 9000.0f && this.m_21223_() >= 3200.0f) {
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.295);
                    this.m_21051_(Attributes.f_22281_).m_22100_(40.0);
                } else {
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.1);
                    this.m_21051_(Attributes.f_22281_).m_22100_(21.0);
                }
                if (!(this.m_21223_() >= 9000.0f)) break block11;
                if (this.m_20096_() && this.m_20184_().m_82556_() > 0.1) {
                    this.handleLandingImpact();
                }
                if (this.m_9236_().f_46443_) break block12;
                if (this.dashCooldown > 0) {
                    --this.dashCooldown;
                }
                if (this.dashCooldown != 0 || this.random.nextInt(100) >= 5) break block12;
                this.performLeap();
                break block12;
            }
            if (this.m_21223_() <= 9000.0f && this.m_21223_() >= 3200.0f) {
                if (this.summonCooldown > 0) {
                    --this.summonCooldown;
                }
                if (this.summonCooldown == 0 && this.random.nextInt(100) == 1) {
                    this.performSummon();
                }
            } else {
                List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(64.0));
                for (Player player : players) {
                    if (player == null || player.m_7500_() || this.m_21224_()) continue;
                    player.m_20334_((this.m_20185_() - player.m_20185_()) * 0.012, (this.m_20186_() - player.m_20186_()) * 0.012, (this.m_20189_() - player.m_20189_()) * 0.012);
                }
            }
        }
    }

    private void handleLandingImpact() {
        AABB areaOfEffect = this.m_20191_().m_82400_(5.0);
        List players = this.m_9236_().m_45976_(Player.class, areaOfEffect);
        for (Player player : players) {
            if (!player.m_6084_()) continue;
            player.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 42.75f);
            this.isDashing = false;
            this.f_19812_ = false;
        }
    }

    public boolean m_5825_() {
        return true;
    }

    protected float m_6431_(@NotNull Pose poseIn, @NotNull EntityDimensions sizeIn) {
        return 2.0f;
    }

    public int m_21230_() {
        return 12;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_215671_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return SoundEvents.f_11668_;
    }

    @Override
    public BossEvent.BossBarColor getBarColor() {
        return BossEvent.BossBarColor.BLUE;
    }

    public boolean m_7327_(@NotNull Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof Player) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)EffectsRegistry.EXHAUSTION.get(), 120, 0));
                if (this.m_21223_() > 9000.0f) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 1));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.CHAINED.get(), 600, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "dashController", state -> PlayState.STOP).triggerableAnim("reckless_leap", RawAnimation.begin().then("reckless_leap", Animation.LoopType.PLAY_ONCE)).transitionLength(5)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "deathController", state -> PlayState.STOP).triggerableAnim("death", RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE)).transitionLength(5)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "swingController", state -> PlayState.STOP).triggerableAnim("ice_spikes", RawAnimation.begin().then("ice_spikes", Animation.LoopType.PLAY_ONCE)).transitionLength(5)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> animationState) {
        if (animationState.isMoving() && !this.isDashing) {
            animationState.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> animationState) {
        if (this.f_20911_ && animationState.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            if (this.m_21223_() >= 11000.0f) {
                switch (this.random.nextInt(3)) {
                    case 0: {
                        animationState.getController().setAnimation(RawAnimation.begin().then("right_chop", Animation.LoopType.PLAY_ONCE));
                        this.f_20911_ = false;
                        animationState.getController().forceAnimationReset();
                        return PlayState.CONTINUE;
                    }
                    case 1: {
                        animationState.getController().setAnimation(RawAnimation.begin().then("left_chop", Animation.LoopType.PLAY_ONCE));
                        this.f_20911_ = false;
                        animationState.getController().forceAnimationReset();
                        return PlayState.CONTINUE;
                    }
                    case 2: {
                        animationState.getController().setAnimation(RawAnimation.begin().then("headbutt", Animation.LoopType.PLAY_ONCE));
                        this.f_20911_ = false;
                        animationState.getController().forceAnimationReset();
                        return PlayState.CONTINUE;
                    }
                }
            } else {
                if (this.m_21223_() <= 9000.0f && this.m_21223_() >= 3200.0f) {
                    animationState.getController().setAnimation(RawAnimation.begin().then("axe_combo", Animation.LoopType.PLAY_ONCE));
                    this.f_20911_ = false;
                    animationState.getController().forceAnimationReset();
                    return PlayState.CONTINUE;
                }
                animationState.getController().setAnimation(RawAnimation.begin().then("headbutt", Animation.LoopType.PLAY_ONCE));
                this.f_20911_ = false;
                animationState.getController().forceAnimationReset();
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new CustomPathNavigation((Mob)this, level);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

