/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import com.idark.valoria.client.particle.ParticleRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.living.minions.UndeadEntity;
import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.EntityRaglokBomb;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.math.ArcRandom;

public class EntityRaglok
extends EntityDivineBoss {
    private int ability;
    private final int LIGHTNING = 1;
    private final int BLIND = 2;
    private final int BOMBS = 3;
    private final int SLOW = 4;
    private final int SUMMON = 5;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private int abilityCooldown;
    private boolean loaded = false;
    private int rangedAttackCounter;
    private boolean avengeAbilityUsed = false;
    public ArcRandom arcRandom = new ArcRandom();

    public EntityRaglok(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 2000;
    }

    public int getAbility() {
        return this.ability;
    }

    @Override
    public void m_8119_() {
        Player player = this.m_9236_().m_45930_((Entity)this, 30.0);
        super.m_8119_();
        if (!this.loaded && !this.m_9236_().f_46443_) {
            List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82363_(24.0, 24.0, 24.0));
            for (Player p : players) {
                p.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)p, "message.raglok.dare", new Object[0]), true);
            }
            this.loaded = true;
        }
        if (this.f_19803_) {
            this.manageAbilities();
            for (int i = 0; i < 4; ++i) {
                EntityRaglokBomb var2 = new EntityRaglokBomb((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.RAGLOK_BOMB.get()), this.m_9236_());
                if (player != null) {
                    var2.m_6027_(player.f_19854_, player.f_19855_ + 5.0, player.f_19856_);
                }
                var2.m_20334_((this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) / 5.0, -0.14, (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) / 5.0);
                this.m_9236_().m_7967_((Entity)var2);
                ++this.rangedAttackCounter;
            }
        }
        if (this.m_6084_()) {
            this.manageAbilities();
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.75f;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }

    public void manageAbilities() {
        Object var2;
        this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
        this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22100_(0.0);
        Player player = this.m_9236_().m_45930_((Entity)this, 96.0);
        if (player == null || player.m_7500_() || this.avengeAbilityUsed) {
            return;
        }
        int DEFAULT = 0;
        if (this.abilityCooldown == 0 || this.ability == DEFAULT) {
            this.abilityCooldown = 50;
            switch (this.f_19796_.m_188503_(5)) {
                case 0: {
                    this.ability = 1;
                    this.rangedAttackCounter = 0;
                    break;
                }
                case 1: {
                    this.ability = 2;
                    break;
                }
                case 2: {
                    this.ability = 3;
                    this.rangedAttackCounter = 0;
                    break;
                }
                case 3: {
                    this.ability = 4;
                    break;
                }
                case 4: {
                    this.ability = 5;
                    break;
                }
            }
            this.message();
        } else if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.ability == 2) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 80, 1));
        }
        if (this.ability == 4) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 3));
        }
        if (this.ability == 1) {
            if (this.abilityCooldown % 40 == 0) {
                LightningBolt ent = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                ent.m_6034_(this.prevPlayerX, this.prevPlayerY, this.prevPlayerZ);
                this.m_9236_().m_7967_((Entity)ent);
                ++this.rangedAttackCounter;
            } else if (this.abilityCooldown % 20 == 0) {
                this.prevPlayerX = player.m_20185_();
                this.prevPlayerY = player.m_20186_();
                this.prevPlayerZ = player.m_20189_();
            }
            if (this.rangedAttackCounter == 32) {
                this.ability = DEFAULT;
            }
        }
        if (this.ability == 3) {
            if (this.abilityCooldown % 45 == 0) {
                int i;
                for (i = 0; i < 8; ++i) {
                    if (!this.m_9236_().f_46443_) continue;
                    ((ParticleBuilder)ParticleBuilder.create((RegistryObject)ParticleRegistry.SPHERE).addVelocity(0.0, (double)0.1f, 0.0)).setTransparencyData(GenericParticleData.create((float)0.225f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)this.arcRandom.randomValueUpTo(0.15f), (float)0.0f).build()).setColorData(ColorParticleData.create((float)255.0f, (float)22.0f, (float)5.0f).build()).setLifetime(1).spawn(this.m_9236_(), this.m_20185_(), 1.0 + this.m_20186_() + 0.5, this.m_20189_());
                }
                for (i = 0; i < 4; ++i) {
                    var2 = new EntityRaglokBomb((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.RAGLOK_BOMB.get()), this.m_9236_());
                    var2.m_6027_(player.f_19854_, player.f_19855_ + 5.0, player.f_19856_);
                    var2.m_20334_((this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) / 5.0, -0.14, (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) / 5.0);
                    this.m_9236_().m_7967_((Entity)var2);
                    ++this.rangedAttackCounter;
                }
            }
            if (this.rangedAttackCounter == 24) {
                this.ability = DEFAULT;
            }
        }
        if (this.ability == 5) {
            if (this.abilityCooldown % 30 == 0) {
                int i;
                for (i = 0; i < 6; ++i) {
                    var2 = new UndeadEntity((EntityType)EntityTypeRegistry.UNDEAD.get(), this.m_9236_());
                    var2.m_6027_(this.m_20185_(), this.m_20186_() + 5.0, this.m_20189_());
                    var2.setOwner((LivingEntity)this);
                    var2.m_21051_(Attributes.f_22281_).m_22100_(6.0);
                    var2.m_21051_(Attributes.f_22276_).m_22100_(30.0);
                    this.m_9236_().m_7967_((Entity)var2);
                    var2.m_21153_(75.0f);
                    var2.m_5634_(75.0f);
                    ++this.rangedAttackCounter;
                }
                for (i = 0; i < 6; ++i) {
                    if (!this.m_9236_().f_46443_) continue;
                    ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.SKULL).addVelocity(0.0, (double)0.1f, 0.0)).setTransparencyData(GenericParticleData.create((float)0.225f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)this.arcRandom.randomValueUpTo(0.15f), (float)0.0f).build()).setColorData(ColorParticleData.create((float)255.0f, (float)22.0f, (float)5.0f).build()).setLifetime(2).spawn(this.m_9236_(), this.m_20185_() * (double)this.f_19796_.m_188501_(), this.m_20186_() + (double)this.f_19796_.m_188501_() + (double)this.f_19796_.m_216339_(0, 3), this.m_20189_() + (double)this.f_19796_.m_188501_());
                }
            }
            if (this.rangedAttackCounter == 18) {
                this.ability = DEFAULT;
            }
        }
    }

    private void message() {
        List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_(36.0, 36.0, 36.0));
        for (Entity entity : list) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            switch (this.ability) {
                case 1: {
                    this.m_5496_((SoundEvent)SoundRegistry.RAGLOK_GUARDIAN.get(), 15.0f, 1.0f);
                    if (this.m_9236_().f_46443_) break;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.think", new Object[0]), true);
                    break;
                }
                case 2: {
                    this.m_5496_((SoundEvent)SoundRegistry.RAGLOK_DARK.get(), 15.0f, 1.0f);
                    if (this.m_9236_().f_46443_) break;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.future", new Object[0]), true);
                    break;
                }
                case 3: {
                    this.m_5496_((SoundEvent)SoundRegistry.RAGLOK_RAIN.get(), 15.0f, 1.0f);
                    if (this.m_9236_().f_46443_) break;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.rain", new Object[0]), true);
                    break;
                }
                case 4: {
                    this.m_5496_((SoundEvent)SoundRegistry.RAGLOK_NOTHING.get(), 15.0f, 1.0f);
                    if (this.m_9236_().f_46443_) break;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.compare", new Object[0]), true);
                    break;
                }
                case 5: {
                    this.m_5496_((SoundEvent)SoundRegistry.RAGLOK_GUARDIAN.get(), 15.0f, 1.0f);
                    this.m_5496_((SoundEvent)SoundsRegistry.ERUPTION.get(), 1.0f, 1.0f);
                    this.m_5496_((SoundEvent)SoundsRegistry.BLOODHOUND_ABILITY.get(), 1.0f, 1.0f);
                    if (this.m_9236_().f_46443_) break;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.great", new Object[0]), true);
                    break;
                }
            }
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public int m_5792_() {
        return 3;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return super.m_7515_();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.RAGLOK_AVENGE.get();
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_6667_(@NotNull DamageSource source) {
        if (!this.avengeAbilityUsed) {
            Player player;
            if (!this.m_9236_().m_5776_()) {
                List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82363_(30.0, 30.0, 30.0));
                for (Player p : players) {
                    p.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)p, "message.raglok.avenge", new Object[0]), true);
                }
            }
            if ((player = this.m_9236_().m_45930_((Entity)this, 30.0)) != null && !player.m_7500_()) {
                LightningBolt bolt = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                bolt.m_6034_(player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_);
                this.m_9236_().m_7967_((Entity)bolt);
            }
            this.avengeAbilityUsed = true;
        }
        super.m_6667_(source);
    }
}

