/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.EntityWreckBouncingProjectile;
import divinerpg.entities.projectile.EntityWreckExplosiveShot;
import divinerpg.entities.projectile.EntityWreckShot;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class EntityWreck
extends EntityDivineBoss {
    private final int MELEE = 0;
    private final int ARCANA = 1;
    private final int RANGED = 2;
    private final int DEFAULT = 0;
    private final int CHARGE = 1;
    private final int PULL = 2;
    private final int FIRE = 3;
    private final int BOUNCE = 4;
    private final int FREEZE = 5;
    private final int SPEED = 6;
    private final int EXPLOSIONS = 7;
    private final int STRENGTH = 8;
    private int abilityTimer;
    private final boolean dead = false;
    private boolean loaded = false;
    private int ability;
    private int abilityType;

    public EntityWreck(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 1500;
    }

    public void manageAbilities() {
        Player player = this.m_9236_().m_45930_((Entity)this, 64.0);
        if (this.m_21223_() < 3250.0f) {
            this.setAbilityType(2);
        } else if (this.m_21223_() < 7500.0f) {
            this.setAbilityType(1);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.1);
            this.m_7910_((float)this.m_21051_(Attributes.f_22279_).m_22135_());
        } else {
            this.setAbilityType(0);
        }
        if (this.abilityTimer > 0) {
            --this.abilityTimer;
        }
        if (this.getAbilityType() == 1 && (this.getAbility() == 1 || this.getAbility() == 2) || this.getAbilityType() == 2 && (this.getAbility() == 3 || this.getAbility() == 4 || this.getAbility() == 5)) {
            this.setAbility(0);
        }
        if (this.getAbility() == 0 && this.abilityTimer == 0) {
            this.abilityTimer = 50;
            block0 : switch (this.getAbilityType()) {
                case 0: {
                    switch (this.f_19796_.m_188503_(2)) {
                        case 0: {
                            this.setAbility(2);
                            this.m_7910_(0.0f);
                            this.m_21051_(Attributes.f_22279_).m_22100_(0.85);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(1);
                            this.m_21051_(Attributes.f_22279_).m_22100_(0.75);
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.f_19796_.m_188503_(3)) {
                        case 0: {
                            this.setAbility(3);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(4);
                            break block0;
                        }
                        case 2: {
                            this.setAbility(5);
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.f_19796_.m_188503_(3)) {
                        case 0: {
                            this.setAbility(6);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(7);
                            break block0;
                        }
                        case 2: {
                            this.setAbility(8);
                            break block0;
                        }
                    }
                    break;
                }
            }
            this.message();
        }
        if (this.getAbility() == 1 && this.abilityTimer == 0) {
            this.setAbility(0);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.32);
        }
        if (this.getAbility() == 3 && player != null) {
            player.m_20254_(10);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60000, 5));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 60000, 0));
            for (int i = 1; i < 20; ++i) {
                int var2 = (this.m_20183_().m_123341_() - player.m_20183_().m_123341_()) * i / 5;
                int var3 = (this.m_20183_().m_123343_() - player.m_20183_().m_123343_()) * i / 5;
                if (this.m_9236_().m_8055_(new BlockPos(this.m_20183_().m_123341_() - var2, this.m_20183_().m_123342_(), this.m_20183_().m_123343_() - var3)) != Blocks.f_50016_.m_49966_()) continue;
                this.m_9236_().m_7731_(new BlockPos(this.m_20183_().m_123341_() - var2, this.m_20183_().m_123342_(), this.m_20183_().m_123343_() - var3), Blocks.f_50083_.m_49966_(), 0);
            }
            this.setAbility(0);
        }
        if (this.getAbility() == 5 && player != null) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 5));
            this.setAbility(0);
            this.abilityTimer = 100;
        }
        if (!this.m_9236_().m_5776_()) {
            this.performRangedAttack();
        }
    }

    private void message() {
        List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_(64.0, 64.0, 64.0));
        for (Entity entity : list) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            switch (this.getAbility()) {
                case 1: {
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.wreck.charge", new Object[0]), true);
                    break;
                }
                case 2: {
                    this.m_5496_((SoundEvent)SoundRegistry.FEEL_SOUL_ARKSIANE.get(), 1.0f, 1.0f);
                    if (this.m_9236_().f_46443_) break;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.wreck.pull", new Object[0]), true);
                    break;
                }
                case 3: {
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.wreck.fire", new Object[0]), true);
                    break;
                }
                case 5: {
                    this.m_5496_((SoundEvent)SoundRegistry.STOP_AT_ONCE.get(), 1.0f, 1.0f);
                    if (this.m_9236_().f_46443_) break;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.wreck.freeze", new Object[0]), true);
                    break;
                }
                case 6: {
                    this.m_5496_((SoundEvent)SoundRegistry.WRECK_SPEED.get(), 1.0f, 1.0f);
                    if (this.m_9236_().f_46443_) break;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.wreck.speed", new Object[0]), true);
                    break;
                }
                case 7: {
                    this.m_5496_((SoundEvent)SoundRegistry.EXPLOSIONS.get(), 1.0f, 1.0f);
                    if (this.m_9236_().f_46443_) break;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.wreck.explosion", new Object[0]), true);
                    break;
                }
                case 8: {
                    this.m_5496_((SoundEvent)SoundRegistry.WRECK_STRENGTH.get(), 1.0f, 1.0f);
                    if (this.m_9236_().f_46443_) break;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.wreck.strength", new Object[0]), true);
                    break;
                }
            }
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.6875f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && !this.loaded) {
            List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82363_(30.0, 30.0, 30.0));
            for (Player p : players) {
                p.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)p, "message.wreck.run", new Object[0]), true);
                p.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)p, "message.wreck.smell", new Object[0]), true);
            }
            this.m_5496_((SoundEvent)SoundRegistry.WRECK_INTRO.get(), 1.0f, 1.0f);
            this.loaded = true;
        }
        Player player = this.m_9236_().m_45930_((Entity)this, 64.0);
        if (this.getAbility() == 2 && player != null && !player.m_7500_()) {
            player.m_20334_((this.m_20185_() - player.m_20185_()) * 0.024, (this.m_20186_() - player.m_20186_()) * 0.024, (this.m_20189_() - player.m_20189_()) * 0.024);
        }
        this.manageAbilities();
    }

    public boolean m_7327_(@NotNull Entity par1Entity) {
        if (this.getAbilityType() != 0) {
            return false;
        }
        float amount = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        int knockback = 0;
        boolean var4 = par1Entity.m_6469_(par1Entity.m_9236_().m_269111_().m_269333_((LivingEntity)this), amount);
        if (var4) {
            int var5;
            if (this.getAbility() == 2) {
                this.setAbility(1);
                this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
                this.m_21051_(Attributes.f_22279_).m_22100_(0.5);
                knockback = 2;
            }
            if (knockback > 0) {
                par1Entity.m_20334_((double)(-Mth.m_14031_((float)(this.f_19858_ * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(Mth.m_14089_((float)(this.f_19857_ * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.m_20334_(this.m_20184_().f_82479_ * 0.6, this.m_20184_().f_82480_, this.m_20184_().f_82481_ * 0.6);
            }
            if ((var5 = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
                par1Entity.m_20254_(var5 * 4);
            }
        }
        return var4;
    }

    public void performRangedAttack() {
        if (!this.m_6084_() || this.m_5448_() == null || this.m_9236_().m_5776_()) {
            return;
        }
        double x = this.m_5448_().m_20185_() - this.m_20185_();
        double z = this.m_5448_().m_20189_() - this.m_20189_();
        switch (this.getAbility()) {
            case 4: {
                EntityWreckBouncingProjectile projectile = new EntityWreckBouncingProjectile((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.WRECK_BOUNCING_PROJECTILE.get()), this.m_9236_(), (LivingEntity)this, 80);
                double bounceY = this.m_5448_().m_20227_(0.3333333333333333) - projectile.m_20186_();
                double d3 = Mth.m_14116_((float)((float)(x * x + z * z)));
                projectile.m_6686_(x, bounceY + d3 * (double)0.2f, z, 1.6f, 0.5f);
                this.m_9236_().m_7967_((Entity)projectile);
                this.setAbility(0);
                break;
            }
            case 6: {
                if (this.abilityTimer % 3 == 0) {
                    EntityWreckShot shot = new EntityWreckShot((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.WRECK_SHOT.get()), this.m_9236_(), (LivingEntity)this, 50);
                    double shotY = this.m_5448_().m_20227_(0.3333333333333333) - shot.m_20186_();
                    double ws3 = Mth.m_14116_((float)((float)(x * x + z * z)));
                    shot.m_6686_(x, shotY + ws3 * (double)0.2f, z, 1.6f, 0.5f);
                    this.m_9236_().m_7967_((Entity)shot);
                }
                if (this.abilityTimer > 25) break;
                this.setAbility(0);
                break;
            }
            case 7: {
                if (this.abilityTimer % 25 == 0) {
                    EntityWreckExplosiveShot explosiveShot = new EntityWreckExplosiveShot((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.WRECK_EXPLOSIVE_SHOT.get()), (LivingEntity)this, this.m_9236_());
                    double explodeY = this.m_5448_().m_20227_(0.3333333333333333) - explosiveShot.m_20186_();
                    double e3 = Mth.m_14116_((float)((float)(x * x + z * z)));
                    explosiveShot.m_6686_(x, explodeY + e3 * (double)0.2f, z, 1.6f, 0.5f);
                    this.m_9236_().m_7967_((Entity)explosiveShot);
                    explosiveShot.m_6686_(x, explodeY + e3 * (double)0.2f, z, 1.6f, 0.5f);
                    this.m_9236_().m_7967_((Entity)explosiveShot);
                }
                if (this.abilityTimer != 0) break;
                this.setAbility(0);
                break;
            }
            case 8: {
                if (this.abilityTimer % 10 == 0) {
                    EntityWreckShot strengthShot = new EntityWreckShot((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.WRECK_SHOT.get()), this.m_9236_(), (LivingEntity)this, 40);
                    double strengthY = this.m_5448_().m_20227_(0.3333333333333333) - strengthShot.m_20186_();
                    double s3 = Mth.m_14116_((float)((float)(x * x + z * z)));
                    strengthShot.m_6686_(x, strengthY + s3 * (double)0.2f, z, 1.6f, 0.5f);
                }
                if (this.abilityTimer != 0) break;
                this.setAbility(0);
                break;
            }
        }
    }

    public int getAbilityType() {
        return this.abilityType;
    }

    public void setAbilityType(int type) {
        this.abilityType = type;
    }

    public int getAbility() {
        return this.ability;
    }

    public void setAbility(int ability) {
        this.ability = ability;
    }

    @Override
    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(1, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.f_21345_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public int m_5792_() {
        return 3;
    }

    public boolean m_5825_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return super.m_7515_();
    }
}

